% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{loo_subsample.brmsfit}
\alias{loo_subsample.brmsfit}
\alias{loo_subsample}
\title{Efficient approximate leave-one-out cross-validation (LOO) using subsampling}
\usage{
\method{loo_subsample}{brmsfit}(x, ..., compare = TRUE, resp = NULL, model_names = NULL)
}
\arguments{
\item{x}{A \code{brmsfit} object.}

\item{...}{More \code{brmsfit} objects or further arguments
passed to the underlying post-processing functions.
In particular, see \code{\link{extract_draws}} for further
supported arguments.}

\item{compare}{A flag indicating if the information criteria
of the models should be compared to each other
via \code{\link{loo_compare}}.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{model_names}{If \code{NULL} (the default) will use model names 
derived from deparsing the call. Otherwise will use the passed 
values as model names.}
}
\description{
Efficient approximate leave-one-out cross-validation (LOO) using subsampling
}
\details{
More details can be found on
\code{\link[loo:loo_subsample]{loo_subsample}}.
}
\examples{
\dontrun{
# model with population-level effects only
fit1 <- brm(rating ~ treat + period + carry,
            data = inhaler)
(loo1 <- loo_subsample(fit1))

# model with an additional varying intercept for subjects
fit2 <- brm(rating ~ treat + period + carry + (1|subject),
            data = inhaler)
(loo2 <- loo_subsample(fit2))   

# compare both models
loo_compare(loo1, loo2)                      
}

}
