% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_marginal_draws.R
\name{brm_marginal_draws}
\alias{brm_marginal_draws}
\title{MCMC draws from the marginal posterior of an MMRM}
\usage{
brm_marginal_draws(
  model,
  data = model$brms.mmrm_data,
  formula = model$brms.mmrm_formula,
  transform = brms.mmrm::brm_transform_marginal(data = data, formula = formula,
    average_within_subgroup = average_within_subgroup),
  effect_size = attr(formula, "brm_allow_effect_size"),
  average_within_subgroup = NULL,
  use_subgroup = NULL,
  control = NULL,
  baseline = NULL
)
}
\arguments{
\item{model}{A fitted model object from \code{\link[=brm_model]{brm_model()}}.}

\item{data}{A classed data frame from \code{\link[=brm_data]{brm_data()}}, or an informative
prior archetype from a function like \code{\link[=brm_archetype_successive_cells]{brm_archetype_successive_cells()}}.}

\item{formula}{An object of class \code{"brmsformula"} from \code{\link[=brm_formula]{brm_formula()}}
or \code{brms::brmsformula()}. Should include the full mapping
of the model, including fixed effects, residual correlation,
and heterogeneity in the discrete-time-specific residual variance
components.}

\item{transform}{Matrix with one row per marginal mean and one column
per model parameter. \code{\link[=brm_marginal_draws]{brm_marginal_draws()}} uses this matrix
to map posterior draws of model parameters to posterior draws of
marginal means using matrix multiplication. Please use
\code{\link[=brm_transform_marginal]{brm_transform_marginal()}} to compute this matrix and then modify
only if necessary. See the methods vignettes for details on this
matrix, as well as how \code{brms.mmrm} computes marginal means more
generally.}

\item{effect_size}{Logical, \code{TRUE} to derive posterior samples
of effect size (treatment effect divided by residual standard
deviation). \code{FALSE} to omit. \code{brms.mmrm} does not support
effect size when baseline or covariates are included
in the \code{\link[=brm_formula_sigma]{brm_formula_sigma()}} formula. If \code{effect_size} is \code{TRUE}
in this case, then \code{\link[=brm_marginal_draws]{brm_marginal_draws()}} will automatically
omit effect size and throw an informative warning.}

\item{average_within_subgroup}{\code{TRUE}, \code{FALSE}, or \code{NULL} to control
whether nuisance parameters are averaged within subgroup levels
in \code{\link[=brm_transform_marginal]{brm_transform_marginal()}}. Ignored if the \code{transform} argument
is manually supplied by the user. See the help page of
\code{\link[=brm_transform_marginal]{brm_transform_marginal()}} for details on the
\code{average_within_subgroup} argument.}

\item{use_subgroup}{Deprecated. No longer used. \code{\link[=brm_marginal_draws]{brm_marginal_draws()}}
no longer marginalizes over the subgroup declared
in \code{\link[=brm_data]{brm_data()}}. To marginalize over the subgroup, declare
that variable in \code{covariates} instead.}

\item{control}{Deprecated. Set the control group level in \code{\link[=brm_data]{brm_data()}}.}

\item{baseline}{Deprecated. Set the control group level in \code{\link[=brm_data]{brm_data()}}.}
}
\value{
A named list of tibbles of MCMC draws of the marginal posterior
distribution of each treatment group and time point. These marginals
are also subgroup-specific if \code{\link[=brm_formula]{brm_formula()}} included fixed effects
that use the \code{subgroup} variable originally declared in \code{\link[=brm_data]{brm_data()}}.
In each tibble, there is 1 row per posterior sample and one column for
each type of marginal distribution (i.e. each combination of treatment
group and discrete time point. The specific \code{tibble}s in the returned
list are described below:
\itemize{
\item \code{response}: on the scale of the response variable.
\item \code{difference_time}: change from baseline: the
\code{response} at a particular time minus the \code{response} at baseline
(\code{reference_time}).
Only returned if the \code{reference_time} argument of \code{\link[=brm_data]{brm_data()}} was
not \code{NULL} (i.e. if a baseline value for the time variable
was identified).
\item \code{difference_group}: treatment effect:
These samples depend on the values of \code{reference_group} and
\code{reference_time} which were originally declared in \code{\link[=brm_data]{brm_data()}}.
\code{reference_group} is the control group, and \code{reference_time}
is baseline. If baseline was originally given (via \code{reference_time}
in \code{\link[=brm_data]{brm_data()}}),
then \code{difference_time} is the change-from-baseline value of
each active group minus that of the control group.
Otherwise, if baseline is omitted (i.e. \code{reference_time = NULL}
(default) in \code{\link[=brm_data]{brm_data()}}), then \code{difference_time} is the
raw response at each active group minus that of the control group.
\item \code{difference_subgroup}: subgroup differences: the \code{difference_group}
at each subgroup level minus the \code{difference_group} at the subgroup
reference level (\code{reference_subgroup}). Only reported if a subgroup
analysis was specified through the appropriate arguments to
\code{\link[=brm_data]{brm_data()}} and \code{\link[=brm_formula]{brm_formula()}}.
\item \code{effect}: effect size, defined as the treatment difference
divided by the residual standard deviation. Omitted if
the \code{effect_size} argument is \code{FALSE} or if the
\code{\link[=brm_formula_sigma]{brm_formula_sigma()}} includes baseline or covariates.
\item \code{sigma}: posterior draws of linear-scale marginal standard deviations
of residuals. Omitted if
the \code{effect_size} argument is \code{FALSE} or if the
\code{\link[=brm_formula_sigma]{brm_formula_sigma()}} includes baseline or covariates.
}
}
\description{
Get marginal posterior draws from a fitted MMRM.
}
\section{Baseline}{

The returned values from \code{\link[=brm_marginal_draws]{brm_marginal_draws()}}
depend on whether a baseline time point
was declared through the \code{reference_time} argument of \code{\link[=brm_data]{brm_data()}}.
If \code{reference_time} was not \code{NULL}, then \code{\link[=brm_marginal_draws]{brm_marginal_draws()}} will
calculate change from baseline, and it will calculate treatment
differences as differences between change-from-baseline values.
If \code{reference_time} was not \code{NULL}, then \code{\link[=brm_marginal_draws]{brm_marginal_draws()}} will
not calculate change from baseline, and it will calculate treatment
differences as differences between response values.
}

\section{Separation string}{

Post-processing in \code{\link[=brm_marginal_draws]{brm_marginal_draws()}} names each of the
group-by-time marginal means with the delimiting character string
from \code{Sys.getenv("BRM_SEP", unset = "|")}. Neither the column names
nor element names of the group and time variables can contain
this string. To set a custom string yourself, use
\code{Sys.setenv(BRM_SEP = "YOUR_CUSTOM_STRING")}.
}

\examples{
if (identical(Sys.getenv("BRM_EXAMPLES", unset = ""), "true")) {
set.seed(0L)
data <- brm_data(
  data = brm_simulate_simple()$data,
  outcome = "response",
  group = "group",
  time = "time",
  patient = "patient",
  reference_group = "group_1",
  reference_time = "time_1"
)
formula <- brm_formula(
  data = data,
  baseline = FALSE,
  baseline_time = FALSE
)
tmp <- utils::capture.output(
  suppressMessages(
    suppressWarnings(
      model <- brm_model(
        data = data,
        formula = formula,
        chains = 1,
        iter = 100,
        refresh = 0
      )
    )
  )
)
brm_marginal_draws(data = data, formula = formula, model = model)
}
}
\seealso{
Other marginals: 
\code{\link{brm_marginal_data}()},
\code{\link{brm_marginal_draws_average}()},
\code{\link{brm_marginal_grid}()},
\code{\link{brm_marginal_probabilities}()},
\code{\link{brm_marginal_summaries}()}
}
\concept{marginals}
