% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_prior_simple.R
\name{brm_prior_simple}
\alias{brm_prior_simple}
\title{Simple prior for a \code{brms} MMRM}
\usage{
brm_prior_simple(
  data,
  formula,
  intercept = "student_t(3, 0, 2.5)",
  coefficients = "student_t(3, 0, 2.5)",
  sigma = "student_t(3, 0, 2.5)",
  unstructured = "lkj(1)",
  autoregressive = "",
  moving_average = "",
  compound_symmetry = "",
  correlation = NULL
)
}
\arguments{
\item{data}{A classed data frame from \code{\link[=brm_data]{brm_data()}}, or an informative
prior archetype from a function like \code{\link[=brm_archetype_successive_cells]{brm_archetype_successive_cells()}}.}

\item{formula}{An object of class \code{"brmsformula"} from \code{\link[=brm_formula]{brm_formula()}}
or \code{brms::brmsformula()}. Should include the full mapping
of the model, including fixed effects, residual correlation,
and heterogeneity in the discrete-time-specific residual variance
components.}

\item{intercept}{Character of length 1, Stan code for the prior
to set on the intercept parameter.}

\item{coefficients}{Character of length 1, Stan code for the prior
to set independently on each of the non-intercept model coefficients.}

\item{sigma}{Character of length 1, Stan code for the prior
to set independently on each of the log-scale standard deviation
parameters. Should be a symmetric prior in most situations.}

\item{unstructured}{Character of length 1,
Stan code for an unstructured correlation prior.
Supply the empty string \code{""} to set a flat prior (default).
Applies to the \verb{"cortime} parameter class in \code{brms} priors.
Used for formulas created with
\code{brm_formula(correlation = "unstructured")}. LKJ is recommended.
See also \code{\link[brms:unstr]{brms::unstr()}}.}

\item{autoregressive}{Character of length 1,
Stan code for a prior on autoregressive correlation parameters.
Supply the empty string \code{""} to set a flat prior (default).
Applies to the \verb{"ar} parameter class in \code{brms} priors.
Used for formulas created with
\code{brm_formula(correlation = "autoregressive")} and
\code{brm_formula(correlation = "autoregressive_moving_average")}.
See also \code{\link[brms:ar]{brms::ar()}} and \code{\link[brms:arma]{brms::arma()}}.}

\item{moving_average}{Character of length 1,
Stan code for a prior on moving average correlation parameters.
Supply the empty string \code{""} to set a flat prior (default).
Applies to the \verb{"ma} parameter class in \code{brms} priors.
Used for formulas created with
\code{brm_formula(correlation = "moving_average")} and
\code{brm_formula(correlation = "autoregressive_moving_average")}.
See also \code{\link[brms:ma]{brms::ma()}} and \code{\link[brms:arma]{brms::arma()}}.}

\item{compound_symmetry}{Character of length 1,
Stan code for a prior on compound symmetry correlation parameters.
Supply the empty string \code{""} to set a flat prior (default).
Applies to the \verb{"cosy} parameter class in \code{brms} priors.
Used for formulas created with
\code{brm_formula(correlation = "compound_symmetry")}.
See also \code{\link[brms:cosy]{brms::cosy()}}.}

\item{correlation}{Deprecated on 2024-04-22
(version 0.1.0.9004). Please use arguments like \code{"unstructured"},
and/or \code{"autoregressive"} to supply correlation-specific priors.}
}
\value{
A classed data frame with the \code{brms} prior.
}
\description{
Generate a simple prior for a \code{brms} MMRM.
}
\details{
In \code{\link[=brm_prior_simple]{brm_prior_simple()}}, you can separately choose priors for
the intercept, model coefficients, log-scale standard deviations,
and pairwise correlations between time points within patients.
However, each class of parameters is set as a whole. In other words,
\code{\link[=brm_prior_simple]{brm_prior_simple()}} cannot assign different priors
to different fixed effect parameters.
}
\examples{
set.seed(0L)
data <- brm_simulate_outline()
data <- brm_simulate_continuous(data, names = c("age", "biomarker"))
formula <- brm_formula(
  data = data,
  baseline = FALSE,
  baseline_time = FALSE,
  check_rank = FALSE
)
brm_prior_simple(
  data = data,
  formula = formula,
  intercept = "student_t(3, 0, 2.5)",
  coefficients = "normal(0, 10)",
  sigma = "student_t(2, 0, 4)",
  unstructured = "lkj(2.5)"
)
}
\seealso{
Other priors: 
\code{\link{brm_prior_archetype}()},
\code{\link{brm_prior_label}()}
}
\concept{priors}
