% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_simulate_continuous.R
\name{brm_simulate_continuous}
\alias{brm_simulate_continuous}
\title{Append simulated continuous covariates}
\usage{
brm_simulate_continuous(data, names, mean = 0, sd = 1)
}
\arguments{
\item{data}{Classed \code{tibble} as from \code{\link[=brm_data]{brm_data()}}
or \code{\link[=brm_simulate_outline]{brm_simulate_outline()}}.}

\item{names}{Character vector with the names of the new covariates
to simulate and append. Names must all be unique and
must not already be column names of \code{data}.}

\item{mean}{Numeric of length 1,
mean of the normal distribution for simulating each covariate.}

\item{sd}{Positive numeric of length 1,
standard deviation of the normal distribution
for simulating each covariate.}
}
\value{
A classed \code{tibble}, like from \code{\link[=brm_data]{brm_data()}} or
\code{\link[=brm_simulate_outline]{brm_simulate_outline()}}, but with new numeric covariate columns
and with the names of the new covariates appended to the
\code{brm_covariates} attribute.
}
\description{
Simulate and append non-time-varying continuous
covariates to an existing \code{\link[=brm_data]{brm_data()}} dataset.
}
\details{
Each covariate is a new column of the dataset with one independent
random univariate normal draw for each patient.
All covariates simulated this way are
independent of everything else in the data, including other covariates
(to the extent that the random number generators in R work as intended).
}
\examples{
data <- brm_simulate_outline()
brm_simulate_continuous(
  data = data,
  names = c("age", "biomarker")
)
brm_simulate_continuous(
  data = data,
  names = c("biomarker1", "biomarker2"),
  mean = 1000,
  sd = 100
)
}
\seealso{
Other simulation: 
\code{\link{brm_simulate_categorical}()},
\code{\link{brm_simulate_outline}()},
\code{\link{brm_simulate_prior}()},
\code{\link{brm_simulate_simple}()}
}
\concept{simulation}
