% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brk_exposure.R
\name{brk_exposure}
\alias{brk_exposure}
\title{Compute exposure for a `RasterStack` class object from package `raster`}
\usage{
brk_exposure(
  RasterStack_dispersal,
  sf,
  key,
  keyTime,
  loss,
  beta,
  nbr_cores,
  quiet,
  unit
)
}
\arguments{
\item{RasterStack_dispersal}{RasterStack. An object of class\code{RasterStack} (see package \code{raster} for details).}

\item{sf}{sf. And object of class `sf` on which exposure is computed from the previous
list of raster by patch `RasterStack_dispersal`. See \link[sf]{sf} for details.}

\item{key}{name of the column in `sf` object providing emission amount}

\item{keyTime}{name o the column of sf for time}

\item{loss}{numeric. scalar or vector (of the same length as the number the timeline include is argument sf) to apply a loss on exposure cells.}

\item{beta}{numeric. toxic adherence parameter between 0 and 1 (default = 0.4).}

\item{nbr_cores}{integer. Set the number of cores to used for parallel computing.}

\item{quiet}{boolean. Set `TRUE` to remove progress bar.}

\item{unit}{default is meter \code{"m"}. but should be more generic: "any".}
}
\description{
Compute exposure for a `RasterStack` class object from package `raster`
}
\details{
Local intensity depends of \code{beta} and \code{alpha} parameters.
Beta represents the toxic adherence between [0,1].
Alpha represents a list of parameters of the lost of toxic particules
due to covariates (precipitation).
There are two configurations to integrate the loss in the function :
(i) simulating covariate (simulate=TRUE) or (ii) uploading covariate (simulate=FALSE).
The covariate is linked to the loss by a linear regression with paramaters minalpha,
maxalpha, covariate_threshold.
}
