% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Individuals-Methods.R
\name{simulateIndividuals}
\alias{simulateIndividuals}
\title{Wrapper function SimulateIndividuals}
\usage{
simulateIndividuals(objectL, n = 200, mintime = 1, maxtime, dob,
  life_duration, toxic_threshold)
}
\arguments{
\item{objectL}{A \link{Landscape} object}

\item{n}{Number of individuals to simulate}

\item{mintime}{Start simulation time}

\item{maxtime}{End simulation time}

\item{dob}{A vector for the Date Of Birth of each individual between \code{mintime} and \code{maxtime}}

\item{life_duration}{A vector for the life duration of each individual}

\item{toxic_threshold}{A vector for the internal toxic threshold value leading to death for each individual}
}
\value{
A S4 \link{Individuals-class} object
}
\description{
This function simulates individuals as an Individuals object.

Will simulate \code{n} individuals in receptors fields of a \link{Landscape}.
}
\details{
The Individuals object output includes for each individual the coordinates, the date of birth, the life duration, the toxic threshold and the internal toxic concentration.
}
\examples{
data(maize_65)
nb_ind=100 ; time_min=1 ; time_max=61
birth_dates=sample(time_min:time_max, size=nb_ind, replace=TRUE)
life_expectancies=rep(20, nb_ind)
toxic_gap=rep(15, nb_ind)
## generate exposed individuals
ind=simulateIndividuals(maize.landscape, n=nb_ind, mintime=time_min,
                        maxtime=time_max, dob=birth_dates,
                        life_duration=life_expectancies, toxic_threshold=toxic_gap)
plot(maize.landscape,ind)
}
\seealso{
\link{loadIndividuals}
}
