% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uc-volumes.R
\name{db_uc_volumes_list}
\alias{db_uc_volumes_list}
\title{List Volumes (Unity Catalog)}
\usage{
db_uc_volumes_list(
  catalog,
  schema,
  max_results = 10000,
  include_browse = TRUE,
  page_token = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{catalog}{Parent catalog of volume}

\item{schema}{Parent schema of volume}

\item{max_results}{Maximum number of volumes to return (default: 10000).}

\item{include_browse}{Whether to include volumes in the response for which
the principal can only access selective metadata for.}

\item{page_token}{Opaque token used to get the next page of results. Optional.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
List
}
\description{
List Volumes (Unity Catalog)
}
\seealso{
Other Unity Catalog Volume Management: 
\code{\link{db_uc_volumes_create}()},
\code{\link{db_uc_volumes_delete}()},
\code{\link{db_uc_volumes_get}()},
\code{\link{db_uc_volumes_update}()}
}
\concept{Unity Catalog Volume Management}
