% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{get_and_start_cluster}
\alias{get_and_start_cluster}
\title{Get and Start Cluster}
\usage{
get_and_start_cluster(
  cluster_id,
  polling_interval = 5,
  host = db_host(),
  token = db_token(),
  silent = FALSE
)
}
\arguments{
\item{cluster_id}{Canonical identifier for the cluster.}

\item{polling_interval}{Number of seconds to wait between status checks}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{silent}{Boolean (default: \code{FALSE}), will emit cluster state progress
if \code{TRUE}.}
}
\value{
\code{db_cluster_get()}
}
\description{
Get and Start Cluster
}
\details{
Get information regarding a Databricks cluster. If the cluster is
inactive it will be started and wait until the cluster is active.
}
\seealso{
\code{\link[=db_cluster_get]{db_cluster_get()}} and \code{\link[=db_cluster_start]{db_cluster_start()}}.

Other Clusters API: 
\code{\link{db_cluster_create}()},
\code{\link{db_cluster_edit}()},
\code{\link{db_cluster_events}()},
\code{\link{db_cluster_get}()},
\code{\link{db_cluster_list}()},
\code{\link{db_cluster_list_node_types}()},
\code{\link{db_cluster_list_zones}()},
\code{\link{db_cluster_perm_delete}()},
\code{\link{db_cluster_pin}()},
\code{\link{db_cluster_resize}()},
\code{\link{db_cluster_restart}()},
\code{\link{db_cluster_runtime_versions}()},
\code{\link{db_cluster_start}()},
\code{\link{db_cluster_terminate}()},
\code{\link{db_cluster_unpin}()},
\code{\link{get_latest_dbr}()}

Other Cluster Helpers: 
\code{\link{get_latest_dbr}()}
}
\concept{Cluster Helpers}
\concept{Clusters API}
