% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getYears.R
\name{getYears}
\alias{getYears}
\title{Get a list of years for a given theme, with the total number of sets in each.}
\usage{
getYears(theme, key = getOption("brickset_key"), ...)
}
\arguments{
\item{theme}{the theme}

\item{key}{the Brickset API key.}

\item{...}{other parameters passed to \code{\link{getUserHash}} including
the Brickset username and password if they are not available from
\code{getOption('brickset_username')} and \code{getOption('brickset_password')}.}
}
\value{
a data.frame with the years of a given theme.
\describe{
\item{theme}{Name of the theme}
\item{year}{Year}
\item{setCount}{Number of sets released in the given year and theme}
}
}
\description{
Get a list of years for a given theme, with the total number of sets in each.
}
\examples{
\dontrun{
options(brickset_key = 'BRICKSET_KEY',
        brickset_username = 'BRICKSET_UERNAME',
        brickset_password = 'BRICKSET_PASSWORD')
getYears('Architecture')
}
}
