% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-bricks-rgl.R
\name{build_bricks}
\alias{build_bricks}
\title{Build 3D brick model with 'rgl'}
\usage{
build_bricks(
  brick_list,
  background_color = "white",
  rgl_lit = TRUE,
  outline_bricks = FALSE,
  trans_alpha = 0.5,
  view_levels = NULL
)
}
\arguments{
\item{brick_list}{List output from a \code{bricks_from_*} function. Contains an element \code{Img_lego}.}

\item{background_color}{Default 'white'. Color of the background.}

\item{rgl_lit}{Default 'TRUE'. Include RGL lighting features in rendering.}

\item{outline_bricks}{Default 'FALSE'. Include black outlines around brick edges.
Set to 'TRUE' and rgl_lit='FALSE' for cartoon-looking bricks.}

\item{trans_alpha}{Default 0.5. Alpha level for transparent bricks.}

\item{view_levels}{Numeric array of Levels/z values to display. Leave as 'NULL' to include all.}
}
\value{
3D brick model rendered in the 'rgl' package.
}
\description{
Render the output of any of the \code{bricks_from_*} functions as a 3D model. Opens an 'rgl' window.
}
\examples{
#This is a brick
brick <- data.frame(
 Level="A",
 X1 = rep(3,4), #The number 3 is the brickrID for 'bright red'
 X2 = rep(3,4)
)

#Convert the dataframe to a list object that can be rendered
brick_object <- brick \%>\% 
 bricks_from_table() 
 
#Render it
brick_object \%>\% 
 build_bricks()

rgl::clear3d()
 
#Combine the option rgl_lit=FALSE & outline_bricks=TRUE 
# This makes the rendering look like a drawing
brick_object \%>\% 
 build_bricks(outline_bricks = TRUE, rgl_lit = FALSE,
              background_color = "#99e7ff")
rgl::clear3d()

}
\seealso{
Other 3D Models: 
\code{\link{bricks_from_coords}()},
\code{\link{bricks_from_excel}()},
\code{\link{bricks_from_mosaic}()},
\code{\link{bricks_from_table}()}
}
\concept{3D Models}
