% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_breathtest_data.R
\name{simulate_breathtest_data}
\alias{simulate_breathtest_data}
\title{Simulate 13C breath time series data}
\usage{
simulate_breathtest_data(n_records = 10, m_mean = 40, m_std = NULL,
  k_mean = 0.01, k_std = NULL, beta_mean = 2, beta_std = NULL,
  noise = 1, cov = NULL, student_t_df = NULL, missing = 0,
  seed = NULL, dose = 100, first_minute = 5, step_minute = 15,
  max_minute = 155)
}
\arguments{
\item{n_records}{Number of records}

\item{m_mean, m_std}{Mean and between-record standard deviation of parameter m giving metabolized fraction.}

\item{k_mean, k_std}{Mean and between-record standard deviation of parameter k, in units of 1/minutes.}

\item{beta_mean, beta_std}{Mean and between-record standard deviations of lag parameter beta}

\item{noise}{Standard deviation of normal noise when \code{student_t_df = NULL}; scaling of noise when student_t_df >= 2.}

\item{cov}{Covariance matrix, default NULL, i.e. not used. If given, overrides 
standard deviation settings.}

\item{student_t_df}{When NULL (default), Gaussian noise is added; when >= 2, Student_t distributed noise is added, which generates more realistic outliers. Values from 2 to 5 are useful, when higher values are used the result comes close to that of Gaussian noise. Values below 2 are truncated to 2.}

\item{missing}{When 0 (default), all curves have the same number of data points. When > 0, this is the fraction of points that were removed randomly to simulate missing}

\item{seed}{Optional seed; not set if seed = NULL (default)}

\item{dose}{Octanoate/acetate dose, almost always 100 mg, which is also the default}

\item{first_minute}{First sampling time. Do not use 0 here, some algorithms do not 
converge when data near 0 are passed.}

\item{step_minute}{Inter-sample interval for breath test}

\item{max_minute}{Maximal time in minutes.}
}
\value{
A list of class simulated_breathtest_data with 2  elements:
\describe{
  \item{record}{Data frame with columns
    \code{patient_id(chr), m, k, beta, t50} giving the effective parameters 
    for the individual patient record.}
  \item{data}{Data frame with columns
    \code{patient_id(chr), minute(dbl), pdr(dbl)} giving the
     time series and grouping parameters.}
 }
 A comment is attached to the return value that can be used as a title for plotting.
}
\description{
Generates simulated breath test data, optionally with errors. If none of the three
standard deviations \code{m_std, k_std, beta_std} is given, an empirical covariance
matrix from USZ breath test data is used. If any of the standard deviations is given,
default values for the others will be used.
}
\examples{
library(ggplot2)
pdr = simulate_breathtest_data(n_records = 4, seed = 4711, missing = 0.3,
       student_t_df = 2, noise = 1.5) # Strong outliers
#
str(pdr, 1)  
#
pdr$record # The "correct" parameters
#
# Explicit plotting
ggplot(pdr$data, aes(x = minute, y = pdr)) + geom_point() +
  facet_wrap(~patient_id) + ggtitle(comment(pdr$data))
#
# Or use cleanup_data and null_fit for S3 plotting
plot(null_fit(cleanup_data(pdr$data)))
}
