% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBS.R
\name{NBS}
\alias{NBS}
\title{Network-based statistic for brain MRI data}
\usage{
NBS(A, covars, alternative = c("two.sided", "less", "greater"),
  p.init = 0.001, N = 1000, symmetric = FALSE)
}
\arguments{
\item{A}{Three-dimensional array of all subjects' connectivity matrices}

\item{covars}{A \code{data.table} of covariates}

\item{alternative}{Character string, whether to do a two- or one-sided test
(default: 'two.sided')}

\item{p.init}{Numeric; the initial p-value threshold (default: 0.001)}

\item{N}{Integer; the number of permutations (default: 1e3)}

\item{symmetric}{Logical indicating if input matrices are symmetric (default:
FALSE)}
}
\value{
A list containing:
\item{g.nbs}{The \code{igraph} graph object based on the initial threshold}
\item{obs}{Integer vector of the observed connected component sizes}
\item{perm}{Integer vector of the permutation distribution of largest
  connected component sizes}
\item{p.perm}{Numeric vector of the permutation p-values for each component}
}
\description{
Calculates the \emph{network-based statistic (NBS)}, which allows for
family-wise error (FWE) control over network data, introduced for brain MRI
data by Zalesky et al. Accepts a three-dimensional array of all subjects'
connectivity matrices and a \code{data.table} of covariates, and creates a
null distribution of the largest connected component size by permuting
subjects. If you would like to perform a t-test at each element, then supply
a covariates \code{data.table} with only a \emph{Study.ID} and \emph{Group}
column. The graph that is returned by this function will have a
\code{t.stat} edge attribute which is the t-statistic for that particular
connection.
}
\examples{
\dontrun{
max.comp.nbs <- NBS(A.norm.sub[[1]], covars.dti, N=5e3)
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\references{
Zalesky A., Fornito A., Bullmore E.T. (2010) \emph{Network-based
  statistic: identifying differences in brain networks}. NeuroImage,
  53(4):1197-1207.
}

