% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{drawdeltaOR1}
\alias{drawdeltaOR1}
\title{Samples \eqn{\delta} in the OR1 model}
\usage{
drawdeltaOR1(y, x, beta, delta0, d0, D0, tune, Dhat, p)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{beta}{Gibbs draw of \eqn{\beta}, column vector of size \eqn{(k x 1)}.}

\item{delta0}{initial value for \eqn{\delta}.}

\item{d0}{prior mean for \eqn{\delta}.}

\item{D0}{prior covariance matrix for \eqn{\delta}.}

\item{tune}{tuning parameter to adjust MH acceptance rate.}

\item{Dhat}{negative inverse Hessian from maximization of log-likelihood.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components
 \item{\code{deltaReturn}: }{\eqn{\delta}, a column vector of size \eqn{((J-2) x 1)}, sampled using MH algorithm.}
  \item{\code{accept}: }{indicator for acceptance of the proposed value of \eqn{\delta}.}
}
\description{
This function samples the cut-point vector \eqn{\delta} using a
random-walk Metropolis-Hastings algorithm in the OR1 model (ordinal
quantile model with 3 or more outcomes).
}
\details{
Samples the cut-point vector \eqn{\delta} using a random-walk Metropolis-Hastings algorithm.
}
\examples{
set.seed(101)
data("data25j4")
y <- data25j4$y
xMat <- data25j4$x
p <- 0.25
beta <- c(0.3990094, 0.8168991, 2.8034963)
delta0 <- c(-0.9026915, -2.2488833)
d0 <- matrix(c(0, 0),
                 nrow = 2, ncol = 1, byrow = TRUE)
D0 <- matrix(c(0.25, 0.00, 0.00, 0.25),
                    nrow = 2, ncol = 2, byrow = TRUE)
tune <- 0.1
Dhat <- matrix(c(0.046612180, -0.001954257, -0.001954257, 0.083066204),
             nrow = 2, ncol = 2, byrow = TRUE)
p <- 0.25
output <- drawdeltaOR1(y, xMat, beta, delta0, d0, D0, tune, Dhat, p)

# deltareturn
#   -0.9025802 -2.229514
# accept
#   1

}
\references{
Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Chib, S., and Greenberg, E. (1995). `"Understanding the Metropolis-Hastings Algorithm."`
The American Statistician, 49(4): 327-335. DOI: 10.2307/2684568

Jeliazkov, I., and Rahman, M. A. (2012). `"Binary and Ordinal Data Analysis in Economics: Modeling and Estimation"`
in Mathematical Modeling with Multidisciplinary
Applications, edited by X.S. Yang, 123-150. John Wiley & Sons Inc, Hoboken, New Jersey. DOI: 10.1002/9781118462706.ch6
}
\seealso{
NPflow, Gibbs sampling, \link[NPflow]{mvnpdf}
}
