% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bqror.R
\docType{package}
\name{bqror}
\alias{bqror}
\title{Bayesian quantile regression for ordinal models}
\description{
Provides functions for estimating Bayesian quantile regression
for ordinal models, calculating covariate effects, and computing measures for
model comparison. Specifically, the package offers two estimation functions -
one for an ordinal model with more than three outcomes. For each ordinal model,
the package provides functions to calculate the covariate effect using the MCMC
outputs. The package also computes marginal likelihood (recommended) and the
Deviance Information Criterion (DIC) for comparing alternative quantile regression
models. Besides, the package also contains functions for making trace plots of MCMC draws
and other functions that aids the estimation or inference of quantile ordinal models.
}
\details{
\deqn{Package: bqror}
\deqn{Type: Package}
\deqn{Version: 1.2.0}
\deqn{License: GPL (>=2)}

Package \strong{bqror} provides the following functions:

\itemize{
\item{For an Ordinal Model with three outcomes:}
}
\code{\link[bqror]{quantreg_or2}}, \code{\link[bqror]{drawlatent_or2}},
\code{\link[bqror]{drawbeta_or2}}, \code{\link[bqror]{drawsigma_or2}},
\code{\link[bqror]{drawnu_or2}}, \code{\link[bqror]{deviance_or2}},
\code{\link[bqror]{qrnegLogLike_or2}}, \code{\link[bqror]{rndald}},
\code{\link[bqror]{traceplot_or2}}, \code{\link[bqror]{infactor_or2}},
\code{\link[bqror]{covariateEffect_or2}},\code{\link[bqror]{logMargLikelihood_or2}}

\itemize{
\item{For an Ordinal Model with more than three outcomes:}
}
\code{\link[bqror]{quantreg_or1}}, \code{\link[bqror]{qrminfundtheorem}},
\code{\link[bqror]{qrnegLogLikensum_or1}}, \code{\link[bqror]{drawbeta_or1}},
\code{\link[bqror]{draww_or1}}, \code{\link[bqror]{drawlatent_or1}},
\code{\link[bqror]{drawdelta_or1}}, \code{\link[bqror]{deviance_or1}},
\code{\link[bqror]{alcdfstd}}, \code{\link[bqror]{alcdf}},
\code{\link[bqror]{traceplot_or1}}, \code{\link[bqror]{infactor_or1}},
\code{\link[bqror]{covariateEffect_or1}}, \code{\link[bqror]{logMargLikelihood_or1}}
}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Yu, K., and Moyeed, R. A. (2001). “Bayesian Quantile Regression.” Statistics and
Probability Letters, 54(4): 437–447. DOI: 10.1016/S0167-7152(01)00124-9

Koenker, R., and Bassett, G. (1978).“Regression Quantiles.” Econometrica,
46(1): 33-50. DOI: 10.2307/1913643

Greenberg, E. (2012). “Introduction to Bayesian Econometrics.”
Cambridge University Press. Cambridge, DOI: 10.1017/CBO9781139058414
}
\seealso{
\link[GIGrvg]{rgig}, \link[MASS]{mvrnorm}, \link[MASS]{ginv},
\link[truncnorm]{rtruncnorm}, \link[NPflow]{mvnpdf},
\link[invgamma]{rinvgamma}, \link[pracma]{mldivide},
\link[pracma]{rand}, \link[stats]{qnorm},
\link[stats]{rexp}, \link[stats]{rnorm},
\link[pracma]{std}, \link[stats]{sd}, \link[stats]{acf},
\link[pracma]{Reshape}, \link[tcltk]{setTkProgressBar},
\link[tcltk]{tkProgressBar}, \link[invgamma]{dinvgamma}
}
\author{
Mohammad Arshad Rahman

Prajual Maheshwari <prajual1391@gmail.com>
}
