% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRI.R
\name{drawdelta_or1}
\alias{drawdelta_or1}
\title{Samples \eqn{\delta} for an ordinal model
with more than 3 outcomes}
\usage{
drawdelta_or1(y, x, beta, delta0, d0, D0, tune, Dhat, p)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{beta}{Gibbs draw of coefficients of dimension \eqn{(k x 1)}.}

\item{delta0}{initial value for \eqn{\delta}.}

\item{d0}{prior mean of normal distribution.}

\item{D0}{prior variance for normal distribution to sample \eqn{\delta}.}

\item{tune}{tuning parameter to adjust MH acceptance rate.}

\item{Dhat}{negative inverse Hessian from maximization of log-likelihood.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components
\itemize{
 \item{\code{deltaReturn}: }{a vector with \eqn{\delta} values using MH algorithm.}
  \item{\code{accept}: }{an indicator for acceptance of proposed value of \eqn{\delta}.}
}
}
\description{
This function samples the \eqn{\delta} using a
random-walk Metropolis-Hastings algorithm for an ordinal
model with more than 3 outcomes.
}
\details{
Samples the \eqn{\delta} using a random-walk Metropolis-Hastings algorithm.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
p <- 0.25
beta <- c(0.3990094, 0.8168991, 2.8034963)
delta0 <- c(-0.9026915, -2.2488833)
d0 <- matrix(c(0, 0),
                 nrow = 2, ncol = 1, byrow = TRUE)
D0 <- matrix(c(0.25, 0.00, 0.00, 0.25),
                    nrow = 2, ncol = 2, byrow = TRUE)
tune <- 0.1
Dhat <- matrix(c(0.046612180, -0.001954257, -0.001954257, 0.083066204),
             nrow = 2, ncol = 2, byrow = TRUE)
p <- 0.25
output <- drawdelta_or1(y, x, beta, delta0, d0, D0, tune, Dhat, p)

# deltareturn
#   -0.9025802 -2.229514
# accept
#   1

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

 Chib, S., Greenberg E. (1995). "Understanding the Metropolis-Hastings
 Algorithm." The American Statistician, 49(4): 327-335.

 Hastings, W.K. (1970). "Monte Carlo Sampling Methods Using
 Markov Chains and Their Applications." Biometrika, 57: 1317-1340.
}
\seealso{
NPflow, Gibbs sampling, \link[NPflow]{mvnpdf}
}
