% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRI.R
\name{quan_regg3}
\alias{quan_regg3}
\title{Bayesian Quantile Regression for Ordinal Models
with more than 3 outcomes}
\usage{
quan_regg3(y, x, mc = 15000, p, tune = 0.1)
}
\arguments{
\item{y}{dependent variable i.e. ordinal outcome values.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{mc}{number of MCMC iterations, post burn-in.}

\item{p}{quantile level or skewness parameter, p in (0,1).}

\item{tune}{tuning parameter.}
}
\value{
Returns a list with components:
\itemize{
\item{\code{post_mean_beta}: }{a vector with mean of sampled
 \eqn{\beta} for each covariate.}
 \item{\code{post_mean_beta}: }{a vector with mean of sampled
 \eqn{\beta} for each covariate.}
 \item{\code{post_mean_delta}: }{a vector with mean of sampled
 \eqn{\delta} for each cut point.}
 \item{\code{post_std_beta}: }{a vector with standard deviation
 of sampled \eqn{\beta} for each covariate.}
 \item{\code{post_std_delta}: }{a vector with standard deviation
 of sampled \eqn{\delta} for each cut point.}
 \item{\code{gamma}: }{a vector of cut points including Inf and
 -Inf.}
 \item{\code{catt}}
 \item{\code{acceptance_rate}: }{a scalar to judge the acceptance
 rate of samples.}
 \item{\code{DIC_result}: }{results of the DIC criteria.}
 \item{\code{beta_draws}: }{a matrix with all sampled values for \eqn{\beta}.}
 \item{\code{delta_draws}: }{a matrix with all sampled values for \eqn{\delta}.}
}
}
\description{
This function estimates the Bayesian Quantile Regression for ordinal models with
more than 3 outcomes and reports the posterior mean and posterior standard deviations
of \eqn{(\beta, \delta)}.
}
\details{
Function implements the Bayesian quantile regression for
ordinal models with more than 3 outcomes using a combination of Gibbs sampling
procedure and Metropolis-Hastings algorithm.

Function initialises prior and then iteratively
samples \eqn{\beta}, \eqn{\delta} and latent variable z.
Burn-in is taken as \eqn{0.25*mc} and \eqn{iter = burn}-\eqn{in + mc}.
}
\examples{
 set.seed(101)
 data("data25j4")
 x <- data25j4$x
 y <- data25j4$y
 p <- 0.25
 ans <- quan_regg3(y, x, mc = 50, p, 0.1)

 # post_mean_beta
 #   -1.429465  1.135585  2.107666
 # post_mean_delta
 #   -0.9026915 -2.2488833
 # post_std_beta
 #   0.2205048 0.2254232 0.2138562
 # post_std_delta
 #   0.08928597 0.15501941
 # gamma
 #   0.0000000
 #   0.4054768
 #   0.5109938
 # catt
 #   0.48870702 0.04928897 0.01202798 0.44997603
 # acceptancerate
 #   84
 # DIC_result
 # DIC
 #  616.2173
 # pd
 #  24.95203
 # devpostmean
 #  566.3133
 # beta_draws
 #   0.8062498 -5.000849 -1.2760778 -3.4372516 -1.43872552
 #   0.3855340 -2.500238 -0.1594546 -1.2534485 -0.04680966
 #   0.7940649 -0.552560  0.1777754  0.9850913  0.56634550 ... soon
 # delta_draws
 #   -1.111202 -1.105643 -1.098417 -1.084080 -1.052632
 #   -2.165620 -2.105090 -2.148234 -2.230976 -2.255488 ... soon

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

Yu, K. and Moyeed, R. A. (2001). “Bayesian Quantile Regression.” Statistics and
Probability Letters, 54(4): 437–447.

Casella, G., George E. I. (1992). “Explaining the Gibbs Sampler."
The American Statistician, 46(3): 167-174.

Geman, S., and Geman, D. (1984). “Stochastic Relaxation,
Gibbs Distributions, and the Bayesian Restoration of Images."
IEEE Transactions an Pattern Analysis and Machine Intelligence,
6(6): 721-741.

 Chib, S., Greenberg E. (1995). "Understanding the Metropolis-Hastings
 Algorithm." The American Statistician, 49(4): 327-335.

 Hastings, W.K. (1970). "Monte Carlo Sampling Methods Using
 Markov Chains and Their Applications." Biometrika, 57: 1317-1340.
}
\seealso{
tcltk, \link[stats]{rnorm}, \link[stats]{qnorm},
\link[MASS]{ginv}, Gibbs sampler
}
