% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Policy_Opinion}
\alias{Policy_Opinion}
\title{Policy_Opinion
The data-set is based on the survey conducted by American National Election Studies (ANES) in 2010-2012.
This data talks about the public opinion on the pro-growth tax policy, considered to raise the federal
income taxes for couples (individuals) earning more than $250,000 ($200,000) per year.}
\usage{
data(Policy_Opinion)
}
\value{
Returns data with components
\itemize{
\item{\code{Intercept}: }{A column of ones.}
\item{\code{AgeCat}: }{Indicator for Age Category.}
\item{\code{IncomeCat}: }{Indicator for household income > $75,000.}
\item{\code{Bachelors}: }{Individual's highest degree in Bachelors.}
\item{\code{Post.Bachelors}: }{Highest degree in Masters, Professional or Doctorate.}
\item{\code{numComputers}: }{Individual or household owns a computer.}
\item{\code{CellPhone}: }{Individual or household owns a cell phone.}
\item{\code{White}: }{Race of the individual is white.}
\item{\code{y}: }{a matrix of ordinal outcomes.}
}
}
\description{
Policy_Opinion
The data-set is based on the survey conducted by American National Election Studies (ANES) in 2010-2012.
This data talks about the public opinion on the pro-growth tax policy, considered to raise the federal
income taxes for couples (individuals) earning more than $250,000 ($200,000) per year.
}
\details{
The ANES data-set here provides 1,164 observations. The responses from individuals were
recorded as either \emph{oppose, neither favor nor oppose} or \emph{favor} the tax increase.
The sample has 263 (22.59\%), 261 (22.42\%) and 640 (54.98\%) observations in respective categories.
}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

Jeliazkov, I., Graves, J., and Kutzbach, M. (2008). “Fitting and Comparison of Models
for Multivariate Ordinal Outcomes.” Advances in Econometrics: Bayesian Econometrics, 23: 115–156.
}
\seealso{
\href{https://electionstudies.org/data-center/}{ANES},  \href{https://georgewbush-whitehouse.archives.gov/cea/progrowth.html}{Tax Policy}
}
\keyword{datasets}
