% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{residuals.bpnme}
\alias{residuals.bpnme}
\title{Residuals for a Bayesian circular mixed-effects model}
\usage{
\method{residuals}{bpnme}(object, type = "arc", ...)
}
\arguments{
\item{object}{a \code{bpnme object} obtained from the function
\code{\link{bpnme}}.}

\item{type}{the type of residuals, one of \code{c("arc", "cos")}. The
\code{"arc"} residuals are based on a computation of the circular arc
length between predicted value and original outcome. The \code{"cos"}
residuals are based on the cosine of the difference between predicted value
and original outcome.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a matrix (rows = N, columns = iterations) containing residuals for
  each iteration of the MCMC sampler.
}
\description{
Outputs residuals for a Bayesian circular mixed-effects model for each
iteration of the MCMC sampler.
}
\examples{
library(bpnreg)
fit.Maps <- bpnme(pred.I = Error.rad ~ Maze + Trial.type + L.c + (1|Subject),
data = Maps,
its = 100, burn = 1, n.lag = 1)
residuals(fit.Maps)
residuals(fit.Maps, type = "cos")

}
