% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_bpmn.R
\name{create_bpmn}
\alias{create_bpmn}
\title{Create BPMN object.}
\usage{
create_bpmn(nodes, flows, events)
}
\arguments{
\item{nodes}{A data.frame of all nodes, with minimal columns id, name, objectType, gatewayDirection}

\item{flows}{A data.frame of all flows, with minimal columns id, sourceRef, targetRef and objectType}

\item{events}{A data.frame of all events, with minimal columns id, name, objectType}
}
\value{
A BPMN object as a list of data.frames for the BPMN elements and an
  XML document for the XML-based interchange format for the BPMN process.
}
\description{
This creates a BPMN object by specifying a set of tasks, sequence flows,
gateways, and a start and end event.
}
\examples{

library(dplyr)
nodes <- tibble(id = "task", name = "Task name",
objectType = "task", gatewayDirection = NA)
events <- tibble(id = c("start","end"), name = c("Start event","End event"),
objectType = c("startEvent","endEvent"))
flows <- tibble(id = c("flow1","flow2"), name = c("flow1","flow2"),
sourceRef = c("start","task"), targetRef = c("task","end"),
objectType = c("sequenceFlow","sequenceFlow"))
create_bpmn(nodes, flows, events)



}
\author{
Alessio Nigro
}
