% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_visuals_scatter.R
\name{bp_scatter}
\alias{bp_scatter}
\title{Blood Pressure Stage Scatter Plot}
\usage{
bp_scatter(
  data,
  plot_type = c("stages2020", "AHA"),
  subj = NULL,
  group_var = NULL,
  wrap_var = NULL,
  inc_crisis = TRUE,
  inc_low = TRUE
)
}
\arguments{
\item{data}{A processed dataframe resulting from the \code{process_data} function that
contains the \code{SBP}, and \code{DBP} columns, as well as (potentially) other information that can be used for grouping.}

\item{plot_type}{String corresponding to the particular type of plot to be displayed. Default
plot (\code{"stages2020"}) sets the BP stages according to Lee et al (2020) with 8 mutually
exclusive categories. Two additional categories, "Low" or "Crisis", can be determined
through the \code{inc_low} or \code{inc_crisis} function arguments, respectively.
Setting \code{plot_type = "AHA"} will use the stages according to the guidelines
set forth by the American Heart Association (reference: \url{https://www.heart.org/en/health-topics/high-blood-pressure/understanding-blood-pressure-readings})}

\item{subj}{Optional argument. Allows the user to specify and subset specific subjects
from the \code{ID} column of the supplied data set. The \code{subj} argument can be a single
value or a vector of elements. The input type should be character, but the function will
comply with integers so long as they are all present in the \code{ID} column of the data.}

\item{group_var}{A categorical column of the input data set that the individual points are to
be grouped / separated by for a given plot. Cannot contain more than 10 levels (to avoid
overcrowding the plot). This is different from the \code{wrap_var} argument which segments
plots by category. The default value is NULL (no grouping).}

\item{wrap_var}{A categorical column of the input data set that the plots are to be segmented
by. If there are multiple levels such as time of day, or visit number, the output will include a
matrix with each plot corresponding to an individual level. This differs from the \code{group_var}
argument which separates data within the same plot. The default value is NULL (no wrapping).}

\item{inc_crisis}{A TRUE / FALSE indicator of whether or not to include the "Crisis" (Hypertensive)
category to the scatter plot. This is only activated in conjunction with \code{"stages2020"} plot type, and if TRUE is defined as SBP > 180 or DBP > 120. If FALSE, those values are displayed as either "ISH - S2", "S2" or "IDH - S2" stages (see details). This argument is ignored with plot type \code{"AHA"}, where the "Crisis" stage (SBP > 180 or DBP > 120) is always displayed.}

\item{inc_low}{A TRUE / FALSE indicator of whether or not to include the "Low" (Hypotension)
category to the scatter plot. This is only activated in conjunction with \code{"stages2020"} plot type, and if TRUE is defined as SBP < 100 and DBP > 60. If FALSE, those values are displayed as "Normal". This argument is ignored with plot type \code{"AHA"}, where the "Low" stage (SBP < 100 and DBP < 60) is always displayed.}
}
\value{
A scatter plot graphic using the ggplot2 package overlaying each reading (represented as
points) onto a background that contains each stage
}
\description{
Display all \code{SBP} and \code{DBP}
readings on a scatterplot with deliniation of BP according to the 8
mutually exclusive levels of Hypertension as in Lee et al (2020) (the default), or the
levels set by the American Heart Association (AHA).
}
\details{
There are eight total stages according to Lee et al (2020) with the options
to include two additional categories for "Low" (Hypotension) and Hypertensive "Crisis". The
categories are as follows:

\itemize{

\item \code{Low} - (Optional) Legacy category for consistency with AHA stages. According to the AHA, low blood pressure is any reading with SBP < 100 and DBP < 60, and is depicted in light blue in the scatter plot. This is always displayed in \code{"AHA"} plot, and can be displayed in \code{"stages2020"} plot by setting \code{inc_low = TRUE}.

\item \code{Normal} -  \code{SBP} readings less than 120 and \code{DBP} readings
less than 80. Reading within this range that either have SBP > 100 or DBP > 60 are also considered Normal by AHA. Normal BP is depicted in green in the scatter plot.

\item \code{Elevated} - \code{SBP} readings between 120 - 129 and \code{DBP}
readings less than 80. Coincides with Elevated stage as defined by AHA. Without intervention to control the condition, individuals are likely to develop Hypertension. Elevated BP is depicted in yellow in the scatter plot.

\item \code{Stage 1 - All (SDH)} - \code{SBP} readings between 130 - 139 and \code{DBP}
readings between 80 - 89. Stage 1 Hypertension will typically result in doctors prescribing
medication or lifestyle changes.  Stage 1 BP is depicted in dark orange in the scatter plot. These readings correspond to Stage 1 as defined by AHA.

\item \code{Stage 1 - Isolated Diastolic Hypertension (IDH)} - \code{SBP} readings
less than 130, but \code{DBP} readings between 80 - 89. This alternative stage 1 level accounts
for unusually high diastolic readings, but fairly normal systolic readings and is depicted in
orange in the plot. These readings correspond to Stage 1 as defined by AHA.

\item \code{Stage 1 - Isolated Systolic Hypertension (ISH)} - \code{SBP} readings
between 130 - 139, but \code{DBP} readings less than 80. This alternative stage 1 level accounts
for unusually high systolic readings, but fairly normal diastolic readings and is depicted in
orange in the plot. These readings correspond to Stage 1 as defined by AHA.

\item \code{Stage 2 - All (SDH)} - \code{SBP} readings between 140 - 180 and \code{DBP} readings
between 90 - 120. Stage 2 Hypertension will typically result in doctors prescribing both
medication and lifestyle changes. Stage 2 BP is depicted in bright red in the scatter plot. These readings correspond to Stage 2 as defined by AHA.

\item \code{Stage 2 - Isolated Diastolic Hypertension (IDH)} - \code{SBP} readings
less than or equal to 140, but \code{DBP} readings greater than or equal to 90. This alternative
stage 2 level accounts for unusually high diastolic readings, but fairly normal systolic readings
and is depicted in red. These readings correspond to Stage 2 as defined by AHA.

\item \code{Stage 2 - Isolated Systolic Hypertension (IDH)} - \code{SBP} readings
greater than or equal to 140, but \code{DBP} readings less or equal to 90. This alternative
stage 2 level accounts for unusually high systolic readings, but fairly normal diastolic readings
and is depicted in red. These readings correspond to Stage 2 as defined by AHA.

\item \code{Crisis} - (Optional) Legacy category for consistency with AHA stages. According to the AHA, hypertensive crisis is defined as a \code{SBP} reading exceeding 180 or a
\code{DBP} reading exceeding 120. This stage requires medical attention immediately.
Crisis is depicted in red in the scatter plot. This is always displayed in \code{"AHA"} plot, and can be displayed in \code{"stages2020"} plot by setting \code{inc_crisis = TRUE}.

}
}
\examples{
data("bp_jhs")
data("bp_hypnos")
data("bp_ghana")
hypnos_proc <- process_data(bp_hypnos,
                         bp_type = 'abpm',
                         sbp = "syst",
                         dbp = "DIAST",
                         date_time = "date.time",
                         id = "id",
                         wake = "wake",
                         visit = "visit",
                         hr = "hr",
                         map = "map",
                         rpp = "rpp",
                         pp = "pp",
                         ToD_int = c(5, 13, 18, 23))

jhs_proc <- process_data(bp_jhs,
                         sbp = "Sys.mmHg.",
                         dbp = "Dias.mmHg.",
                         date_time = "DateTime",
                         hr = "pulse.bpm.")
rm(bp_hypnos, bp_jhs)

# HYPNOS Data
bp_scatter(hypnos_proc,
           inc_crisis = TRUE,
           inc_low = TRUE,
           group_var = "wake",
           wrap_var = "day_of_week")

# JHS Data
bp_scatter(jhs_proc,
           plot_type = "AHA",
           group_var = "time_of_day")

# Ghana Data Set
#(Note that column names are of proper naming convention so no processing needed)
bp_scatter(bp::bp_ghana, inc_crisis = TRUE, inc_low = FALSE, group_var = "TIME_ELAPSED")
}
\references{
Lee H, Yano Y, Cho SMJ, Park JH, Park S, Lloyd-Jones DM, Kim HC. Cardiovascular risk of isolated
systolic or diastolic hypertension in young adults. \emph{Circulation}. 2020; 141:1778–1786.
\doi{10.1161/CIRCULATIONAHA.119.044838}

Unger, T., Borghi, C., Charchar, F., Khan, N. A., Poulter, N. R., Prabhakaran, D., ... & Schutte,
A. E. (2020). 2020 International Society of Hypertension global hypertension practice guidelines.
\emph{Hypertension}, 75(6), 1334-1357.
\doi{10.1161/HYPERTENSIONAHA.120.15026}
}
