% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_report.R
\name{bp_report}
\alias{bp_report}
\title{Blood Pressure Report}
\usage{
bp_report(
  data,
  subj = NULL,
  inc_low = TRUE,
  inc_crisis = TRUE,
  group_var = NULL,
  save_report = TRUE,
  path = NULL,
  filename = "bp_report",
  width = 11,
  height = 8.5,
  filetype = "pdf",
  units = "in",
  scale = 1.25,
  plot = TRUE
)
}
\arguments{
\item{data}{Required argument. A processed dataframe resulting from the \code{process_data}
function to properly format data set. In order for the \code{bp_report} function to work properly,
the following variables must be present and properly formatted:
\itemize{

\item{\code{SBP}}
\item{\code{DBP}}
\item{\code{DATE_TIME}} - Used in the \code{process_data} function to create additional columns
that are needed for the \code{bp_report} function (SBP_Category, DBP_Category, Weekday, and
Time_of_Day.)
\item{\code{SBP_CATEGORY}} - Automatically calculated in the \code{process_data} function
\item{\code{DBP_CATEGORY}} - Automatically calculated in the \code{process_data} function
\item{\code{DAY_OF_WEEK}} - Automatically calculated in the \code{process_data} function
\item{\code{TIME_OF_DAY}} - Automatically calculated in the \code{process_data} function
\item{\code{ID}} - (If applicable) Used for separating out different individuals, if more than one
\item{\code{VISIT}} - (If applicable) Used for separating out an individuals' different visits,
if more than one

}}

\item{subj}{Optional argument. Allows the user to specify and subset specific subjects
from the \code{ID} column of the supplied data set. The \code{subj} argument can be a single
value or a vector of elements. The input type should be character, but the function will
comply with integers so long as they are all present in the \code{ID} column of the data.}

\item{inc_low}{Optional logical argument dictating whether or not to include the "Low" category for BP
classification column (and the supplementary SBP/DBP Category columns). Default set to TRUE.}

\item{inc_crisis}{Optional logical argument dictating whether or not to include the "Crisis" category for BP
classification column (and the supplementary SBP/DBP Category columns). Default set to TRUE.}

\item{group_var}{A categorical column of the input data set that the individual points are to
be grouped / separated by for a given plot. Cannot contain more than 10 levels (to avoid
overcrowding the plot). This is different from the \code{wrap_var} argument which segments
plots by category and cannot be used with the \code{process_data} function.}

\item{save_report}{A logical value indicating whether to save the BP report output as a separate file.
The default is \code{TRUE} indicating that the report will be saved.}

\item{path}{Optional argument. A string corresponding to the respective file path by which the
report is to be saved. Do not include trailing slashes (i.e. ~/loc/) or the file name (i.e. ~/loc/testfile.pdf).
By default, if not \code{path} argument specified, will save at the current working directory.}

\item{filename}{Optional argument. A string corresponding to the name of the report. The default is
"bp_report". The string cannot begin with a number or non-alphabetical character.
\cr
\cr Note: DO NOT include the file type extension (such as ".pdf" or ".png") at the end of the string;
the \code{bp_report} function will automatically join the name with the file type.}

\item{width}{Optional argument. An numeric value corresponding to the width of the output document.
The default is set to 12 inches.}

\item{height}{Optional argument. An numeric value corresponding to the height of the output document.
The default is set to 8.53 inches.}

\item{filetype}{A string corresponding to he particular type of file that the report is to be saved as.
Although PDF is the default possible options include:
\itemize{

\item{pdf} (default)
\item{png}
\item{jpeg}
\item{tiff}
\item{bmp}
\item{eps}
\item{ps}

}}

\item{units}{A character string corresponding to the unit of measurement that the width and height
correspond to in the exported output. The default is inches ("in"), but centimeters ("cm") and
millimeters ("mm") are also available.}

\item{scale}{A multiplicative scaling factor for the report output.}

\item{plot}{A logical value indicating whether to automatically produce the plot of bp_report, or suppress the output. The default value is TRUE. If false, the returned object is a grob that can be plotted using \code{\link{grid.arrange}}}
}
\value{
If \code{plot = TRUE}, the function produces a plot of BP report that contains scatterplot of BP values by stages (see \code{\link{bp_scatter}}), histograms of BP values by stages (see \code{\link{bp_hist}}) and frequency tables of BP values by stages and day of the week/time of the day (see \code{\link{dow_tod_plots}}). If \code{plot = FALSE}, the function returns the grob object that can be plotted later using \code{\link{grid.arrange}}. If \code{save_report = TRUE}, the report will be automatically saved at the current working directory (can be checked using \code{getwd()}) or at specified file path.
}
\description{
The \code{bp_report} function serves to aggregate various data visuals and metrics
pertaining to the supplied data set into a clean formatted report.
}
\examples{

data("bp_jhs")
data("bp_hypnos")
hyp_proc <- process_data(bp_hypnos,
                         sbp = "syst",
                         dbp = "DIAST",
                         date_time = "date.time",
                         id = "id",
                         wake = "wake",
                         visit = "visit",
                         hr = "hr",
                         map = "map",
                         rpp = "rpp",
                         pp = "pp",
                         ToD_int = c(5, 13, 18, 23))

jhs_proc <- process_data(bp_jhs,
                         sbp = "Sys.mmHg.",
                         dbp = "Dias.mmHg.",
                         date_time = "DateTime",
                         hr = "pulse.bpm.")
rm(bp_hypnos, bp_jhs)

# Single-subject Report
# save_report = FALSE for illustrative purposes
# plot = TRUE will automatically generate a plot
bp_report(jhs_proc, save_report = FALSE, plot = TRUE)

# Multi-subject Report
# save_report = FALSE for illustrative purposes
# plot = FALSE will suppress the plot output and return a grob object
out = bp_report(hyp_proc, group_var = 'VISIT', save_report = FALSE, plot = FALSE)
gridExtra::grid.arrange(out)
}
