% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/game_mgmt.R
\name{score_keeper}
\alias{score_keeper}
\title{Calculate Scores and Effect Size}
\usage{
score_keeper(player_values, comp_values, mode)
}
\arguments{
\item{player_values}{A numeric vector representing the values of the player's
cards.}

\item{comp_values}{A numeric vector representing the values of the computer's
cards.}

\item{mode}{A character string representing the mode of the game, either 't'
for independent t-test or 'pt' for paired t-test.}
}
\value{
A list containing:
\itemize{
\item \code{player_sum}: Sum of player's values.
\item \code{player_mean}: Mean of player's values.
\item \code{comp_sum}: Sum of computer's values.
\item \code{comp_mean}: Mean of computer's values.
\item \code{effect_size}: Calculated effect size based on the given mode.
}
}
\description{
This function computes the sum and mean of the player's and computer's values
and calculates the effect size based on the given mode (\code{t} or \code{pt}).
}
\examples{
# Calculate scores for a simple game
player_vals <- c(2.5, 3.0, 4.5)
comp_vals <- c(3.5, 2.0, 4.0)
scores <- score_keeper(player_vals, comp_vals, mode = "t")

}
