% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootImpute.R
\name{bootImpute}
\alias{bootImpute}
\title{Bootstrap then impute an incomplete dataset}
\usage{
bootImpute(
  obsdata,
  impfun,
  nBoot = 200,
  nImp = 2,
  nCores = 1,
  seed = NULL,
  ...
)
}
\arguments{
\item{obsdata}{The data frame to be imputed.}

\item{impfun}{A function which when passed an incomplete dataset will
return a single imputed data frame.}

\item{nBoot}{The number of bootstrap samples to take. It is recommended
that you use a minimum of 200. If you specify \code{nCores>1}, \code{nBoot} must
be a multiple of the specified \code{nCores} value.}

\item{nImp}{The number of times to impute each bootstrap sample. Two
is recommended.}

\item{nCores}{The number of CPU cores to use. If specified greater than one,
\code{bootImpute} will impute using the number of cores specified.}

\item{seed}{Random number seed.}

\item{...}{Other parameters that are to be passed through to \code{impfun}.}
}
\value{
A list of imputed datasets.
}
\description{
Bootstraps an incomplete dataset and then imputes each bootstrap a number
of times. The resulting list of bootstrapped then imputed datasets can
be analysed with \code{\link{bootImputeAnalyse}}.
}
\details{
The \code{impfun} must be a function which when passed an incomplete datasets
and possibly additional arguments, returns a single imputed data frame. Depending
on what imputation function returns by default, you may need to write a small
wrapper function that calls the imputation procedure once and returns the
imputed dataset. See the Example for an illustration with the \code{mice}
package.

To improve computation times, \code{bootImpute} now supports
multiple cores through the \code{nCores} argument which uses the \code{parallel}
package.
}
\examples{
#this example shows how you can use bootImpute to impute using the mice
#package. If you do want to impute using MICE you can instead use the
#bootMice function, which essentially contains the code below
library(mice)

#write a wrapper function to call mice with one imputation and return
#the imputed dataset
impOnce <- function(inputData) {
  oneImp <- mice::mice(inputData, m=1)
  mice::complete(oneImp)
}

#bootstrap twice and impute each twice
#in practice you should bootstrap many more times, e.g. at least 200
imps <- bootImpute(ex_linquad, impOnce, nBoot=2, nImp=2, seed=564764)
}
