% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internalFunctions.R
\name{ssGammaPars}
\alias{ssGammaPars}
\title{Compute the sum of squares between the theoretical and observed quantiles of a gamma distribution.}
\usage{
ssGammaPars(shapeRatePars, qLow, qUpp, alpha = 0.05)
}
\arguments{
\item{shapeRatePars}{The shape and rate parameters of the theoretical gamma distribution.}

\item{qLow}{The observed lower quantile.}

\item{qUpp}{The observed upper quantile.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}
}
\value{
A single number, the sum of squares.
}
\description{
This is a helper function that compute the sum of squares between two theoretical and observed quantiles of a gamma distribution (typically the lower and upper bounds of a confidence interval).
This function is for internal use to find the best-fit gamma distribution for a given confidence interval.
}
\seealso{
\code{\link{identifyGammaPars}}, \code{\link{optim}}, \code{\link{qgamma}}
}
