\name{imp.weights}
\alias{imp.weights}
\title{
Importance Sampling Weights
}
\description{
This function calculates the importance sampling weight required to correct
for simulation from a distribution with probabilities \code{p} when estimates 
are required assuming that simulation was from an alternative distribution 
with probabilities \code{q}.
}
\usage{
imp.weights(boot.out, def=TRUE, q=NULL)
}
\arguments{
\item{boot.out}{
A object of class \code{"boot"} generated by \code{boot} or \code{tilt.boot}.  Typically the 
bootstrap simulations would have
been done using importance resampling and we wish to do our calculations
under the assumption of sampling with equal probabilities.
}
\item{def}{
A logical variable indicating whether the defensive mixture distribution
weights should be calculated.  This makes sense only in the case where the 
replicates in \code{boot.out} were simulated under a number of different 
distributions.  If this is the case then the defensive mixture weights use a 
mixture of the distributions used in the bootstrap.  The alternative is to 
calculate the weights for each replicate using knowledge of the distribution 
from which the bootstrap resample was generated.
}
\item{q}{
A vector of probabilities specifying the resampling distribution from which 
we require inferences to be made. In general this would correspond to the usual
bootstrap resampling distribution which gives equal weight to each of the 
original observations and this is the default.  \code{q} must have length equal
to the number of observations in the \code{boot.out$data} and all elements of \code{q}
must be positive.
}}
\value{
A vector of importance weights of the same length as \code{boot.out$t}.  These 
weights can then be used to reweight \code{boot.out$t} so that estimates can be 
found as if the simulations were from a distribution with probabilities \code{q}.
}
\details{
The importance sampling weight for a bootstrap replicate with frequency
vector \code{f} is given by \code{prod((q/p)^f)}.  This reweights the replicates so that
estimates can be found as if the bootstrap resamples were generated according
to the probabilities \code{q} even though, in fact, they came from the 
distribution \code{p}.
}
\references{
Davison, A. C. and Hinkley, D. V. (1997) 
\emph{Bootstrap Methods and Their Application}. Cambridge University Press.


Hesterberg, T. (1995) Weighted average importance sampling and defensive 
mixture distributions. \emph{Technometrics}, \bold{37}, 185--194.


Johns, M.V.  (1988) Importance sampling for bootstrap confidence intervals.
\emph{Journal of the American Statistical Association}, \bold{83}, 709--714.
}
\seealso{
\code{\link{boot}}, \code{\link{exp.tilt}}, \code{\link{imp.moments}}, \code{\link{smooth.f}}, \code{\link{tilt.boot}}
}
\note{
See the example in the help for \code{imp.moments} for an example of using 
\code{imp.weights}.
}
\keyword{nonparametric}
% Converted by Sd2Rd version 1.15.
