% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_central_t_distribution.R
\name{non_central_t_distribution}
\alias{non_central_t_distribution}
\alias{non_central_t_pdf}
\alias{non_central_t_lpdf}
\alias{non_central_t_cdf}
\alias{non_central_t_lcdf}
\alias{non_central_t_quantile}
\title{Noncentral T Distribution Functions}
\usage{
non_central_t_pdf(x, df, delta)

non_central_t_lpdf(x, df, delta)

non_central_t_cdf(x, df, delta)

non_central_t_lcdf(x, df, delta)

non_central_t_quantile(p, df, delta)
}
\arguments{
\item{x}{quantile}

\item{df}{degrees of freedom (df > 0)}

\item{delta}{noncentrality parameter (delta >= 0)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Noncentral T distribution.
}
\examples{
# Noncentral T distribution with 3 degrees of freedom and noncentrality parameter 1
non_central_t_pdf(0, 3, 1)
non_central_t_lpdf(0, 3, 1)
non_central_t_cdf(0, 3, 1)
non_central_t_lcdf(0, 3, 1)
non_central_t_quantile(0.5, 3, 1)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/dist_ref/dists/nc_t_dist.html}{Boost Documentation} for more details on the mathematical background.
}
