% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_functions.R
\name{error_functions}
\alias{error_functions}
\alias{erf}
\alias{erfc}
\alias{erf_inv}
\alias{erfc_inv}
\title{Error Functions and Inverses}
\usage{
erf(x)

erfc(x)

erf_inv(p)

erfc_inv(p)
}
\arguments{
\item{x}{Input numeric value}

\item{p}{Probability value (0 <= p <= 1)}
}
\value{
A single numeric value with the computed error function, complementary error function, or their inverses.
}
\description{
Functions to compute the error function, complementary error function, and their inverses.
}
\examples{
# Error function
erf(0.5)
# Complementary error function
erfc(0.5)
# Inverse error function
erf_inv(0.5)
# Inverse complementary error function
erfc_inv(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/sf_erf.html}{Boost Documentation} for more details
}
