% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_radar_imagery.R
\name{get_radar_imagery}
\alias{get_radar_imagery}
\title{Get \acronym{BOM} Radar Imagery}
\usage{
get_radar_imagery(product_id, path = NULL, download_only = FALSE)
}
\arguments{
\item{product_id}{Character.  \acronym{BOM} product ID to download and import
as a  \code{\link[raster]{raster}} object. Value is required.}

\item{path}{Character. A character string with the name where the downloaded
file is saved. If not provided, the default value \code{NULL} is used which
saves the file in a temp directory.}

\item{download_only}{Logical. Whether the radar image is loaded into the
environment as a \code{\link[raster]{raster}} layer, or just downloaded.}
}
\value{
A raster layer based on the most recent `.gif' radar image snapshot published
by the \acronym{BOM}. If \code{download_only = TRUE} there will be a `NULL`
return value with the download path printed in the console as a message.
}
\description{
Fetch \acronym{BOM} radar imagery from
\url{ftp://ftp.bom.gov.au/anon/gen/radar/} and return a
\code{\link[raster]{raster}} layer object.  Files available are the most
recent radar snapshot which are updated approximately every 6 to 10 minutes.
Suggested to check file availability first by using
\code{\link{get_available_radar}}.
}
\details{
Valid \acronym{BOM} Radar Product IDs for radar imagery can be
obtained from \code{\link{get_available_radar}}.
}
\examples{
\donttest{
# Fetch most recent radar image for Wollongong 256km radar
library(raster)
imagery <- get_radar_imagery(product_id = "IDR032")
plot(imagery)

# Save imagery to a local path
imagery <- get_radar_imagery(product_id = "IDR032", path = "image.gif")
}

}
\references{
Australian Bureau of Meteorology (BOM) radar images\cr
\url{http://www.bom.gov.au/australia/radar/}
}
\seealso{
\code{\link{get_available_radar}}
}
\author{
Dean Marchiori, \email{deanmarchiori@gmail.com}
}
