% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_precis_forecast.R
\name{get_precis_forecast}
\alias{get_precis_forecast}
\title{Get BOM Daily Précis Forecast for Select Towns}
\usage{
get_precis_forecast(state = "AUS")
}
\arguments{
\item{state}{Australian state or territory as full name or postal code.
Fuzzy string matching via \code{\link[base]{agrep}} is done.  Defaults to
"AUS" returning all state bulletins, see details for further information.}
}
\value{
Tidy \code{\link[base]{data.frame}} of a Australia BOM précis seven day
forecasts for select towns.  For full details of fields and units returned
see Appendix 2 in the \pkg{bomrang} vignette, use \cr
\code{vignette("bomrang", package = "bomrang")} to view.
}
\description{
Fetch the BOM daily précis forecast and return a tidy data frame of the seven
day town forecast for a specified state or territory.
}
\details{
Allowed state and territory postal codes, only one state per request
or all using \code{AUS}.
 \describe{
   \item{ACT}{Australian Capital Territory (will return NSW)}
   \item{NSW}{New South Wales}
   \item{NT}{Northern Territory}
   \item{QLD}{Queensland}
   \item{SA}{South Australia}
   \item{TAS}{Tasmania}
   \item{VIC}{Victoria}
   \item{WA}{Western Australia}
   \item{AUS}{Australia, returns forecast for all states, NT and ACT}
 }
}
\examples{
\dontrun{
BOM_forecast <- get_precis_forecast(state = "QLD")
}
}
\references{
Forecast data come from Australian Bureau of Meteorology (BOM) Weather Data
Services \cr
\url{http://www.bom.gov.au/catalogue/data-feeds.shtml}

Location data and other metadata for towns come from
the BOM anonymous FTP server with spatial data \cr
\url{ftp://ftp.bom.gov.au/anon/home/adfd/spatial/}, specifically the DBF
file portion of a shapefile, \cr
\url{ftp://ftp.bom.gov.au/anon/home/adfd/spatial/IDM00013.dbf}
}
\author{
Adam H Sparks, \email{adamhsparks@gmail.com} and Keith Pembleton,
\email{keith.pembleton@usq.edu.au}
}
