% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bold_tax_name}
\alias{bold_tax_name}
\title{Search BOLD for taxonomy data by taxonomic name.}
\usage{
bold_tax_name(name = NULL, fuzzy = FALSE, response = FALSE, ...)
}
\arguments{
\item{name}{(character) One or more scientific names.}

\item{fuzzy}{(logical) Whether to use fuzzy search or not (default: FALSE).}

\item{response}{(logical) Note that response is the object that returns from the Curl call,
useful for debugging, and getting detailed info on the API call.}

\item{...}{Further args passed on to httr::GET, main purpose being curl debugging}
}
\description{
Search BOLD for taxonomy data by taxonomic name.
}
\examples{
\dontrun{
bold_tax_name(name='Diplura')
bold_tax_name(name='Osmia')
bold_tax_name(name=c('Diplura','Osmia'))
bold_tax_name(name=c("Apis","Puma concolor","Pinus concolor"))
bold_tax_name(name='Diplur', fuzzy=TRUE)
bold_tax_name(name='Osm', fuzzy=TRUE)

## get httr response object only
bold_tax_name(name='Diplura', response=TRUE)
bold_tax_name(name=c('Diplura','Osmia'), response=TRUE)

## curl debugging
library('httr')
bold_tax_name(name='Diplura', config=verbose())
}
}
\references{
\url{http://boldsystems.org/index.php/resources/api?type=taxonomy#nameParameters}
}

