% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/buildJunctionTree-methods.R
\docType{methods}
\name{build.junction.tree}
\alias{build.junction.tree}
\alias{build.junction.tree,InferenceEngine-method}
\alias{build.junction.tree,InferenceEngine}
\title{build a JunctionTree.}
\usage{
build.junction.tree(object, ...)

\S4method{build.junction.tree}{InferenceEngine}(object, ...)
}
\arguments{
\item{object}{an \code{\link{InferenceEngine}} object.}

\item{...}{potential further arguments for methods.}
}
\description{
Starting from the adjacency matrix of the directed acyclic graph of the network
contained in an InferenceEngine, build a JunctionTree for the network
and store it into an InferenceEngine.
}
\examples{
\dontrun{
dataset <- BNDataset("file.header", "file.data")
net <- BN(dataset)
eng <- InferenceEngine()
eng <- build.junction.tree(eng)
}

}
\seealso{
InferenceEngine
}
