% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/em.R
\docType{methods}
\name{em}
\alias{em}
\alias{em,InferenceEngine,BNDataset}
\alias{em,InferenceEngine,BNDataset-method}
\title{expectation-maximization algorithm.}
\usage{
em(x, dataset, threshold = 0.001, max.em.iterations = 10, ess = 1)

\S4method{em}{InferenceEngine,BNDataset}(x, dataset, threshold = 0.001,
  max.em.iterations = 10, ess = 1)
}
\arguments{
\item{x}{an \code{\link{InferenceEngine}}.}

\item{dataset}{observed dataset with missing values for the Bayesian Network of \code{x}.}

\item{threshold}{threshold for convergence, used as stopping criterion.}

\item{max.em.iterations}{maximum number of iterations to run in case of no convergence.}

\item{ess}{Equivalent Sample Size value.}
}
\value{
a list containing: an \code{\link{InferenceEngine}} with a new updated network (\code{"InferenceEngine"}),
        and the imputed dataset (\code{"BNDataset"}).
}
\description{
Learn parameters of a network using the Expectation-Maximization algorithm.
}
\examples{
\dontrun{
em(x, dataset)
}

}

