% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jeffreys.R
\name{Jeffreys.CI}
\alias{Jeffreys.CI}
\title{Jeffreys Divergence for \code{CI}}
\usage{
\method{Jeffreys}{CI}(x, type, entry, delta, ...)
}
\arguments{
\item{x}{object of class \code{CI}.}

\item{type}{character string. Type of model-preserving co-variation: either \code{"total"}, \code{"partial"}, \code{row},\code{column} or \code{all}. If \code{all} the Jeffreys divergence is computed for every type of co-variation matrix.}

\item{entry}{a vector of length 2 indicating the entry of the covariance matrix to vary.}

\item{delta}{numeric vector with positive elements, including the variation parameters that act multiplicatively.}

\item{...}{additional arguments for compatibility.}
}
\value{
A dataframe including in the first column the variations performed, and in the following columns the corresponding Jeffreys divergences for the chosen model-preserving co-variations.
}
\description{
\code{Jeffreys.CI} returns the Jeffreys divergence between an object of class \code{CI}  and its update after a model-preserving parameter variation.
}
\details{
Computation of the Jeffreys divergence between a Bayesian network and its updated version after a model-preserving variation.
}
\examples{
Jeffreys(synthetic_ci,"total",c(1,1),seq(0.9,1.1,0.01))
Jeffreys(synthetic_ci,"partial",c(1,4),seq(0.9,1.1,0.01))
Jeffreys(synthetic_ci,"column",c(1,2),seq(0.9,1.1,0.01))
Jeffreys(synthetic_ci,"row",c(3,2),seq(0.9,1.1,0.01))
Jeffreys(synthetic_ci,"all",c(3,2),seq(0.9,1.1,0.01))

}
\references{
C. Görgen & M. Leonelli (2020), Model-preserving sensitivity analysis for families of Gaussian distributions.  Journal of Machine Learning Research, 21: 1-32.
}
\seealso{
\code{\link{KL.GBN}}, \code{\link{KL.CI}}, \code{\link{Fro.CI}}, \code{\link{Fro.GBN}}, \code{\link{Jeffreys.GBN}}
}
