% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.summary.R
\name{network.cumrank.tx.plot}
\alias{network.cumrank.tx.plot}
\title{Create a treatment cumulative rank plot}
\usage{
network.cumrank.tx.plot(
  result,
  txnames = NULL,
  catnames = NULL,
  legend.position = c(1, 1)
)
}
\arguments{
\item{result}{Object created by \code{\link{network.run}} function}

\item{txnames}{Treatment names used in creating legend}

\item{catnames}{Category names. Only used in multinomial.}

\item{legend.position}{x, y position of the legend}
}
\value{
None
}
\description{
This function creates a treatment cumulative rank plot. Rank preference can be specified by the \code{rank.preference} parameter in \code{\link{network.data}}
}
\examples{
network <- with(blocker, {
 network.data(Outcomes, Study, Treat, N = N, response = "binomial")
})
\donttest{
result <- network.run(network)
network.cumrank.tx.plot(result, txnames = c("control", "beta blocker"))
}
}
\seealso{
\code{\link{rank.tx}}
}
