% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/0bnclassify-doc.R, R/learn-params-awnb.R, R/learn-params.R
\name{learn_params}
\alias{awnb}
\alias{learn_params}
\alias{lp}
\alias{lpawnb}
\title{Learn the parameters of a Bayesian network structure.}
\usage{
awnb(class, dataset, trees = 10, bootstrap_size = 0.5)

lp(x, dataset, smooth)

lpawnb(x, dataset, smooth, trees, bootstrap_size)
}
\arguments{
\item{class}{A character. Name of the class variable.}

\item{dataset}{The data frame from which to estimate network parameters.}

\item{trees}{An integer. The number of bootstrap samples to generate.}

\item{bootstrap_size}{A numeric. The size of the bootstrap subsample,
relative to the size of \code{dataset} (given in [0,1]).}

\item{x}{a \code{\link{bnc_dag_object}} object. The Bayesian network structure.}

\item{smooth}{A nonnegative numeric. The smoothing value for Bayesian
parameter estimation.}
}
\description{
\code{lp} estimates parameters with maximum likelihood or Bayesian
estimation.
}
\details{
\code{lpawnb} extends \code{lp} by weighting the features' CPTs according to
the AWNB method.
}
\references{
Mark Hall (2004). A decision tree-based attribute weighting
  filter for naive Bayes. \emph{Knowledge-based Systems}, \bold{20}(2),
  120-126.
}

