% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metal.R
\docType{data}
\name{metal}
\alias{metal}
\title{metal Bayesian Network}
\format{
A discrete Bayesian network to model the uncertainty surrounding the occurrence of a fly-out accident during metal lathe machining operations and its corresponding consequences. Probabilities were given within the referenced paper. The vertices are:
\describe{
\item{CAF}{Chuck association fault (Okay, Faulty);}
\item{WHF}{Workpiece holding failure (N-Fail, FLRE);}
\item{TPF}{Tool-post fault (Okay, Faulty);}
\item{CF}{Coolant fault (Okay, Faulty);}
\item{OS}{Operating speed (Proper, Improper);}
\item{SGF}{Safety guards faul (Okay, Faulty);}
\item{IFR}{Wrong feed rate (HR, HE);}
\item{FlyOutAccident}{(Fatal, Major, Minor).}
}
}
\value{
An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
}
\description{
Bayesian belief network modeling of accident occurrence in metal lathe machining operations.
}
\references{
Akinyemi, O. O., Adeyemi, H. O., Olatunde, O. B., Folorunsho, O., & Musa, M. B. (2022). Bayesian belief network modeling of accident occurrence in metal lathe machining operations. Mindanao Journal of Science and Technology, 20(2).
}
\keyword{ReverseNaiveBayes}
