% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/vectorialLoss.R
\name{softMarginVectorLoss}
\alias{softMarginVectorLoss}
\title{Soft Margin Vector Loss function for multiclass SVM}
\usage{
softMarginVectorLoss(x, y, l = "0/1")
}
\arguments{
\item{x}{instance matrix, where x(t,) defines the features of instance t}

\item{y}{target vector where y(t) is an integer encoding target of x(t,)}

\item{l}{loss matrix. l(t,p(t)) must be the loss for predicting target p(t) instead of y(t)
for instance t. By default, the parameter is set to character value "0/1" so that the loss is set to a 0/1 loss matrix.}
}
\value{
a function taking one argument w and computing the loss value and the gradient at point w
}
\description{
Soft Margin Vector Loss function for multiclass SVM
}
\examples{
# -- Load the data
  x <- data.matrix(iris[1:2])
  y <- as.integer(iris$Species)

  # -- Add a constant dimension to the dataset to learn the intercept
  cst <- sqrt(max(rowSums(x*x)))
  x <- cbind(x,cst)

  # -- train a multi-class SVM & compute the predictions
  train.multiclassSVM <- function(x,y,...) {
    m <- bmrm(softMarginVectorLoss(x,y),...)
    m$w <- matrix(m$w,ncol(x))
    m$f <- x \%*\% m$w
    m$y <- max.col(m$f)
    m$contingencyTable <- table(y,m$y)
    print(m$contingencyTable)
    return(m)
  }
  # train a L1-regularized multi-class SVM
  m <- train.multiclassSVM(x,y,MAX_ITER=50,regfun='l1',LAMBDA=1)

  # -- Plot the dataset and the decision boundaries
  gx <- seq(min(x[,1]),max(x[,1]),length=200) # positions of the probes on x-axis
  gy <- seq(min(x[,2]),max(x[,2]),length=200) # positions of the probes on y-axis
  Y <- outer(gx,gy,function(a,b){
     max.col(cbind(a,b,cst) \%*\% m$w)
  }) # matrix of predictions for all probes
  layout(matrix(c(1,3,2,3),2,2))
  image(gx,gy,Y,asp=1,main="dataset & decision boundaries",xlab=colnames(x)[1],ylab=colnames(x)[2])
  points(x,pch=19+y)
  plot(m$log$epsilon,type="o",ylab="epsilon gap",xlab="iteration")
  plot(row(m$f),m$f,pch=19+col(m$f),ylab="prediction values",xlab="sample")
}
\references{
Teo et al.
  A Scalable Modular Convex Solver for Regularized Risk Minimization.
  KDD 2007
}

