% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmmformula.R
\name{bmf2bf}
\alias{bmf2bf}
\title{Convert \code{bmmformula} objects to \code{brmsformula} objects}
\usage{
bmf2bf(model, formula)
}
\arguments{
\item{model}{The model object defining one of the supported `bmmodels``}

\item{formula}{The \code{bmmformula} that should be converted to a \code{brmsformula}}
}
\value{
A \code{brmsformula} defining the response variables and the additional parameter
formulas for the specified \code{bmmodel}
}
\description{
Called by \code{\link[=configure_model]{configure_model()}} inside \code{\link[=bmm]{bmm()}} to convert the \code{bmmformula} into a
\code{brmsformula} based on information in the model object. It will call the
appropriate bmf2bf.\* methods based on the classes defined in the model_\* function.
}
\examples{
  model <- mixture2p(resp_error = "error")

  formula <- bmmformula(
    thetat ~ 0 + set_size + (0 + set_size | id),
    kappa ~ 1 + (1 | id)
  )

  brms_formula <- bmf2bf(model, formula)
}
\keyword{developer}
\keyword{internal}
