% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{.sim.bekk}
\alias{.sim.bekk}
\title{Simulate BEKK data.}
\usage{
.sim.bekk(N, C, A, B, phi = NULL, theta = NULL)
}
\arguments{
\item{N}{Integer. Length of time series.}

\item{C}{Numeric square matrix. Constant covariance matrix (C). Must be symmetric.}

\item{A}{Numeric square matrix. Moving average GARCH matrix (A).}

\item{B}{Numeric square matrix. Autoregressive ARCH matrix (B).}

\item{phi}{Numeric square matrix (Optional). Autoregressive coefficients (Phi).}

\item{theta}{Numeric square matrix (Optional). Moving average coefficients (Theta).}
}
\value{
Matrix of observations.
}
\description{
Simulates time series data from specified BEKK model.
}
\details{
Simulates timeseries data from specified BEKK model.
Number of time series computed from the number of columns in C.
All matrices must be of the same dimension.
If ARMA parameters (phi, theta) unspecified (NULL), then assumes a constant mean of zero.
}
\author{
Stephen R. Martin
}
\keyword{internal}
