% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/aggregateHessians.R
\name{aggregateHessians}
\alias{aggregateHessians}
\title{Aggregate constraint Hessians.}
\usage{
aggregateHessians(...)
}
\arguments{
\item{...}{Hessians of constraint functions.}
}
\value{
a function which takes a value \code{X} and returns a 3D array with
with dimensions \code{c(length(X), length(X), length(...))}. The (i,j,k) entry
of the return value is the ij-th partial derivative of the k-th constraint,
evaluated at \code{X}.
}
\description{
Collect Hessian matrices of constraint functions into a 3D array.
}
\examples{
Hg1 <- function(X){
matrix(12 * c(X[1], 0, 0, 0, X[2], 0, 0, 0, X[3])^2, nrow=3, byrow=TRUE)
}

Hg2 <- function(X){
  matrix(c(2, 0, 0, 0, 2, 0, 0, 0, 2), nrow=3, byrow=TRUE)
}

HG <- aggregateHessians(Hg1, Hg2)
HG(c(0,0,0))
}
\seealso{
Other aggregate functions: \code{\link{aggregateConstraints}};
  \code{\link{aggregateGradients}}
}

