% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_explorer.R
\name{cv_block_size}
\alias{cv_block_size}
\title{Explore spatial block size}
\usage{
cv_block_size(r, x = NULL, column = NULL, min_size = NULL, max_size = NULL)
}
\arguments{
\item{r}{a terra SpatRaster object (optional). If provided, its extent will be used to specify the blocks.
It also supports \emph{stars}, \emph{raster}, or path to a raster file on disk.}

\item{x}{a simple features (sf) or SpatialPoints object of spatial sample data. If \code{r} is supplied, this
is only added to the plot. Otherwise, the extent of \code{x} is used for creating the blocks.}

\item{column}{character (optional). Indicating the name of the column in which response variable (e.g.
species data as a binary response i.e. 0s and 1s) is stored to be shown on the plot.}

\item{min_size}{numeric; the minimum size of the blocks (in metres) to explore.}

\item{max_size}{numeric; the maximum size of the blocks (in metres) to explore.}
}
\value{
an interactive shiny session
}
\description{
This function assists selection of block size. It allows the user to visualise the blocks
interactively, viewing the impact of block size on number and arrangement of blocks in
the landscape (and optionally on the distribution of species data in those blocks).
Slide to the selected block size, and click \emph{Apply Changes} to change the block size.
}
\examples{
\donttest{
if(interactive()){
library(blockCV)

# import presence-absence species data
points <- read.csv(system.file("extdata/", "species.csv", package = "blockCV"))
pa_data <- sf::st_as_sf(points, coords = c("x", "y"), crs = 7845)

# manually choose the size of spatial blocks
cv_block_size(x = pa_data,
              column = "occ",
              min_size = 2e5,
              max_size = 9e5)

}
}

}
