% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ggplot.R
\name{add_ggplot}
\alias{add_ggplot}
\title{Helper function for adding an ggplot}
\usage{
add_ggplot(plot_object, width, height)
}
\arguments{
\item{plot_object}{the ggplot plot object.}

\item{width}{the width of the output plot
in inches.}

\item{height}{the height of the output
plot in inches.}
}
\value{
a character object with an HTML
fragment that can be placed inside the
message body wherever the plot image
should appear.
}
\description{
Add an ggplot plot inside the body of the
email with this helper function.
}
\examples{
library(ggplot2)

# Create a ggplot plot
plot <-
  ggplot(
    data = mtcars,
    aes(x = disp, y = hp,
        color = wt, size = mpg)) +
  geom_point()

# Create an HTML fragment that
# contains an the ggplot as an
# embedded plot
plot_html <-
  add_ggplot(
    plot_object = plot,
    height = 5,
    width = 7)

# Include the plot in the email
# message body by simply referencing
# the `plot_html` object
email <-
  compose_email(
  body = "
  Hello!

  Here is a very important plot \\\\
  that will change the way you \\\\
  look at cars forever.

  {plot_html}

  So useful, right?
  ") \%>\% preview_email()
}
