% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimData.R
\name{SimData}
\alias{SimData}
\title{Simulate dataset}
\usage{
SimData(n = 100, M = 5, sigsq.true = 0.5, beta.true = 2, hfun = 3,
  Zgen = "unif", ind = 1:2)
}
\arguments{
\item{n}{Number of observations}

\item{M}{Number of predictor variables to generate}

\item{sigsq.true}{Variance of normally distributed residual error}

\item{beta.true}{Coefficient on the covariate}

\item{hfun}{An integer from 1 to 3 identifying which predictor-response function to generate}

\item{Zgen}{Method for generating the matrix Z of exposure variables, taking one of the values c("unif", "corr", "realistic")}

\item{ind}{select which predictor(s) will be included in the \code{h} function; how many predictors that can be included will depend on which \code{h} function is being used.}
}
\description{
Simulate predictor, covariate, and outcome data
}
\details{
\itemize{
 \item{"hfun = 1"}{A nonlinear function of the first predictor}
 \item{"hfun = 2"}{A linear function of the first two predictors and their product term}
 \item{"hfun = 3"}{A nonlinear and nonadditive function of the first two predictor variables}
}
}
\examples{
set.seed(5)
dat <- SimData()
}

