% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/calendar.R
\name{bizseq}
\alias{bizseq}
\title{Create a sequence of business days}
\usage{
bizseq(from, to, cal = bizdays.options$get("default.calendar"))
}
\arguments{
\item{from}{the initial date}

\item{to}{the final date (must be greater than \code{from})}

\item{cal}{an instance of \code{Calendar}}
}
\value{
A vector of \code{Date} objects that are business days according to the
provided \code{Calendar}.
}
\description{
Returns a sequence of dates with business days only.
}
\section{Date types accepted}{


The arguments \code{from} and \code{to} accept \code{Date} objects and any
object that returns a valid \code{Date} object when passed through
\code{as.Date}, which include all \code{POSIX*} classes and \code{character}
objects with ISO formatted dates.
}
\examples{
data(holidaysANBIMA)
cal <- Calendar(holidaysANBIMA, weekdays=c("saturday", "sunday"))
bizseq("2013-01-02", "2013-01-31", cal)
}

