% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execute_order.R
\name{tn_place_order}
\alias{tn_place_order}
\title{Place an order (testnet)}
\usage{
tn_place_order(
  symbol = NULL,
  side = NULL,
  orderQty = NULL,
  price = NULL,
  displayQty = NULL,
  stopPx = NULL,
  clOrdID = NULL,
  pegOffsetValue = NULL,
  pegPriceType = NULL,
  ordType = NULL,
  timeInForce = NULL,
  execInst = NULL,
  text = NULL
)
}
\arguments{
\item{symbol}{string. Instrument symbol. e.g. 'XBTUSD'.}

\item{side}{string. Order side. Valid options: Buy, Sell. Defaults to 'Buy' unless \code{orderQty}is negative.}

\item{orderQty}{double. Order quantity in units of the instrument (i.e. contracts).}

\item{price}{double. Optional limit price for 'Limit', 'StopLimit', and 'LimitIfTouched' orders.}

\item{displayQty}{double. Optional quantity to display in the book. Use 0 for a fully hidden order.}

\item{stopPx}{double. Optional trigger price for 'Stop', 'StopLimit', 'MarketIfTouched', and 'LimitIfTouched' orders.
Use a price below the current price for stop-sell orders and buy-if-touched orders.
Use \code{execInst} of 'MarkPrice' or 'LastPrice' to define the current price used for triggering.}

\item{clOrdID}{string. Optional Client Order ID. This clOrdID will come back on the order and any related executions.}

\item{pegOffsetValue}{string. Optional trailing offset from the current price for 'Stop', 'StopLimit', '
MarketIfTouched', and 'LimitIfTouched' orders; use a negative offset for stop-sell orders and buy-if-touched orders.
Optional offset from the peg price for 'Pegged' orders.}

\item{pegPriceType}{string. Optional peg price type.
Valid options: LastPeg, MidPricePeg, MarketPeg, PrimaryPeg, TrailingStopPeg.}

\item{ordType}{string. Order type. Valid options: Market, Limit, Stop, StopLimit, MarketIfTouched, LimitIfTouched, Pegged.
Defaults to 'Limit' when \code{price} is specified. Defaults to 'Stop' when \code{stopPx} is specified.
Defaults to 'StopLimit' when \code{price} and \code{stopPx} are specified.}

\item{timeInForce}{string. Time in force. Valid options: Day, GoodTillCancel, ImmediateOrCancel, FillOrKill.
Defaults to 'GoodTillCancel' for 'Limit', 'StopLimit', and 'LimitIfTouched' orders.}

\item{execInst}{string. Optional execution instructions. Valid options: ParticipateDoNotInitiate,
AllOrNone, MarkPrice, IndexPrice, LastPrice, Close, ReduceOnly, Fixed.
'AllOrNone' instruction requires \code{displayQty} to be 0. 'MarkPrice', 'IndexPrice' or 'LastPrice'
instruction valid for 'Stop', 'StopLimit', 'MarketIfTouched', and 'LimitIfTouched' orders.}

\item{text}{string. Optional order annotation. e.g. 'Take profit'.}
}
\value{
Returns a \code{tibble} containing information about the trade that has been placed.
See \url{https://testnet.bitmex.com/api/explorer/#!/Order/Order_new} for more details.
}
\description{
Place an order using the Bitmex testnet API. Requires testnet API key.
}
\examples{
\dontrun{
# place limit order to Buy at specific price
tn_place_order(symbol = "XBTUSD", price = 6000, orderQty = 10)
}

}
