% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucket_trades.R
\name{tn_bucket_trades}
\alias{tn_bucket_trades}
\title{Bucketed trade data (testnet)}
\usage{
tn_bucket_trades(
  binSize = "1m",
  partial = "false",
  symbol = "XBTUSD",
  count = 1000,
  reverse = "true",
  filter = NULL,
  columns = NULL,
  start = NULL,
  startTime = NULL,
  endTime = NULL,
  use_auth = FALSE
)
}
\arguments{
\item{binSize}{character string.
The time interval to bucket by, must be one of: \code{"1m"}, \code{"5m"}, \code{"1h"} or \code{"1d"}.}

\item{partial}{character string. Either \code{"true"} of \code{"false"}.
If \code{"true"}, will send in-progress (incomplete) bins for the current time period.}

\item{symbol}{a character string for the instrument symbol.
Use \code{\link[=available_symbols]{available_symbols()}} to see available symbols.}

\item{count}{an optional integer to specify the number of rows to return.
Maximum of 1000 (the default) per request.}

\item{reverse}{an optional character string. Either \code{"true"} of \code{"false"}.
If \code{"true"}, result will be ordered with starting with the newest (defaults to \code{"true"}).}

\item{filter}{an optional character string for table filtering.
Send JSON key/value pairs, such as \code{"{'key':'value'}"}. See examples.}

\item{columns}{an optional character vector of column names to return.
If \code{NULL}, all columns will be returned.}

\item{start}{an optional integer. Can be used to specify the starting point for results.}

\item{startTime}{an optional character string.
Starting date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{endTime}{an optional character string.
Ending date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{use_auth}{logical. Use \code{TRUE} to enable authentication with API key.}
}
\description{
\code{tn_bucket_trades()} retrieves open high low close (OHLC) data for the specified symbol/time frame.
}
\details{
The API will only return 1000 rows per call. If the desired time frame requires more than one API call,
consider using \code{\link[=tn_map_bucket_trades]{tn_map_bucket_trades()}}.
}
\examples{
\dontrun{

# Return most recent data for symbol `"ETHUSD"` for 1 hour buckets

tn_bucket_trades(
  binSize = "1h",
  symbol = "ETHUSD",
  count = 10
)
}
}
