\name{biotools-package}
\alias{biotools-package}
\alias{biotools}
\docType{package}

\title{ Tools for Biometry and Applied Statistics in Agricultural Science }

\description{
Tools designed to perform and evaluate cluster analysis (including Tocher's algorithm), 
discriminant analysis and path analysis (standard and under collinearity), as well as some 
useful miscellaneous tools for dealing with sample size and optimum plot size calculations. 
A test for seed sample heterogeneity is now available. Mantel's permutation test can be found in this package. 
A new approach for calculating its power is implemented. biotools also contains tests for genetic covariance components.
Heuristic approaches for performing non-parametric spatial predictions of generic response variables and 
spatial gene diversity are implemented.
}

\details{
\tabular{ll}{
Package: \tab biotools\cr
Type: \tab Package\cr
Version: \tab 4.0\cr
Date: \tab 2020-12-04\cr
License: \tab GPL (>= 2)\cr
}
}

\note{
\emph{biotools} is an ongoing project.
Any and all criticism, comments and suggestions are welcomed.
}

\author{
Anderson Rodrigo da Silva

Maintainer: Anderson Rodrigo da Silva <anderson.agro@hotmail.com>
}

\references{
Cruz, C.D.; Ferreira, F.M.; Pessoni, L.A. (2011) \emph{Biometria aplicada ao estudo da diversidade genetica}. Visconde do Rio Branco: Suprema.

Rao, R.C. (1952) \emph{Advanced statistical methods in biometric research}. New York: John Wiley & Sons.

Sharma, J.R. (2006) \emph{Statistical and biometrical techniques in plant breeding}. Delhi: New Age International.

Da Silva, A.R.; Malafaia, G.; Menezes, I.P.P. (2017) biotools: an R function to predict 
   spatial gene diversity via an individual-based approach. \emph{Genetics and Molecular Research}, 
   16: gmr16029655. 

Da Silva, A.R., Silva, A.P.A., Tiago-Neto, L.J. (2020) A new local stochastic method for predicting data with spatial heterogeneity. 
	\emph{ACTA SCIENTIARUM-AGRONOMY}, \bold{43}: e49947.

Silva, A.R. & Dias, C.T.S. (2013) A cophenetic correlation coefficient for Tocher's method. 
	\emph{Pesquisa Agropecuaria Brasileira}, 48: 589-596.

Da Silva, A.R. (2020). On testing for seed sample heterogeneity with the exact probability distribution of the germination count range. 
	\emph{Seed Science Research}, \bold{30}(1): 59-63.
}

\keyword{ package }
