% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_blocks.R
\name{assign_blocks}
\alias{assign_blocks}
\title{Helper to assign block numbers to data according to variables and limits}
\usage{
assign_blocks(data, variable_1, variable_2, n_cols, n_rows = NULL,
              xlb, ylb = NULL, block_type = "equal_area")
}
\arguments{
\item{data}{matrix or data.frame that contains at least four columns:
"Longitude" and "Latitude" to represent geographic position, and two other
columns to represent the variables of the 2D environmental space.}

\item{variable_1}{(character or numeric) name or position of the first
variable (x-axis) to be used to create blocks.}

\item{variable_2}{(character or numeric) name or position of the second
variable (y-axis) to be used to create blocks (must be different from the
first one).}

\item{n_cols}{(numeric) number of columns of a grid used to create blocks
and split the bi-dimensional space.}

\item{n_rows}{(numeric) number of rows of a grid used to create blocks and
split the bi-dimensional space. If NULL, the default, \code{n_rows = n_cols}.}

\item{xlb}{(numeric) vector of values of extremes for all blocks considering
\code{variable_1}.}

\item{ylb}{(numeric) vector of values of extremes for all blocks considering
\code{variable_2}. Needed when \code{block_type} = "equal_area".
Default = NULL.}

\item{block_type}{(character) type of blocks to be used for dividing
the bi-dimensional space. Two options are available: "equal_area" and
"equal_points". Default = "equal_area". Note that this option has important
association regarding full representation of the extreme values of
environmental variables across the study region.}
}
\value{
Original element defined in \code{data} plus a new column named "Block"
defining the block that correspond to each of the points represented in rows.
}
\description{
Helper to assign block numbers to data according to variables and limits
}
\examples{
# Data
dat <- matrix(runif(800), ncol = 4)
xlims <- quantile(dat[, 3])
ylims <- quantile(dat[, 4])

# Assigning blocks
datb <- assign_blocks(dat, variable_1 = 3, variable_2 = 4, n_cols = 10,
                      xlb = xlims, ylb = ylims, block_type = "equal_area")
}
