% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_3.R
\docType{class}
\name{BIOMOD.projection.out}
\alias{BIOMOD.projection.out}
\alias{BIOMOD.projection.out-class}
\alias{plot,BIOMOD.projection.out,missing-method}
\alias{show,BIOMOD.projection.out-method}
\title{\code{BIOMOD_Projection()} output object class}
\usage{
\S4method{plot}{BIOMOD.projection.out,missing}(
  x,
  coord = NULL,
  plot.output,
  do.plot = TRUE,
  std = TRUE,
  scales,
  size,
  maxcell = 5e+05,
  ...
)

\S4method{show}{BIOMOD.projection.out}(object)
}
\arguments{
\item{x}{a \code{\link{BIOMOD.projection.out}} object}

\item{coord}{a 2-columns \code{data.frame} containing the corresponding \code{X} and \code{Y}}

\item{plot.output}{(\emph{optional, default} \code{facet}) a character
determining the type of output: with \code{plot.output = 'list'} the
function will return a list of plots (one plot per model) ; with 'facet' ;
with \code{plot.output = 'facet'} the function will return a single plot
with all asked projections as facet.}

\item{do.plot}{(\emph{optional, default} \code{TRUE}) a boolean determining
whether the plot should be displayed or just returned.}

\item{std}{(\emph{optional, default} \code{TRUE}) a boolean controlling the
limits of the color scales. With \code{std = TRUE} color scales are
displayed between 0 and 1 (or 1000). With \code{std = FALSE} color scales
are displayed between 0 and the maximum value observed.}

\item{scales}{(\emph{optional, default} \code{fixed}) a character
determining whether x and y scales are shared among facet. Argument passed
to \code{\link[ggplot2:facet_wrap]{facet_wrap}}. Possible values: 'fixed', 'free_x',
'free_y', 'free'.}

\item{size}{(\emph{optional, default} \code{0.75}) a numeric determing the
size of points on the plots and passed to
\code{\link[ggplot2:geom_point]{geom_point}}.}

\item{maxcell}{maximum number of cells to plot. Argument transmitted to \code{\link[terra]{plot}}.}

\item{...}{additional parameters to be passed to \code{\link{get_predictions}} 
to select the models that will be plotted}

\item{object}{a \code{\link{BIOMOD.projection.out}} object}
}
\description{
Class returned by \code{\link{BIOMOD_Projection}}, and used by 
\code{\link{BIOMOD_EnsembleForecasting}}
}
\section{Slots}{

\describe{
\item{\code{modeling.id}}{a \code{character} corresponding to the name (ID) of the simulation set}

\item{\code{proj.name}}{a \code{character} corresponding to the projection name}

\item{\code{dir.name}}{a \code{character} corresponding to the modeling folder}

\item{\code{sp.name}}{a \code{character} corresponding to the species name}

\item{\code{expl.var.names}}{a \code{vector} containing names of explanatory variables}

\item{\code{coord}}{a 2-columns \code{matrix} or \code{data.frame} containing the corresponding 
\code{X} and \code{Y} coordinates used to project the species distribution model(s)}

\item{\code{scale.models}}{a \code{logical} value defining whether models have been rescaled or 
not}

\item{\code{models.projected}}{a \code{vector} containing names of projected models}

\item{\code{models.out}}{a \code{\link{BIOMOD.stored.data}} object}

\item{\code{type}}{a \code{character} corresponding to the class of the \code{val} slot of the 
\code{proj.out} slot}

\item{\code{proj.out}}{a \code{\link{BIOMOD.stored.data}} object}
}}

\examples{

showClass("BIOMOD.projection.out")

## ----------------------------------------------------------------------- #
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

## ----------------------------------------------------------------------- #
file.out <- paste0(myRespName, "/", myRespName, ".AllModels.models.out")
if (file.exists(file.out)) {
  myBiomodModelOut <- get(load(file.out))
} else {

  # Format Data with true absences
  myBiomodData <- BIOMOD_FormatingData(resp.var = myResp,
                                       expl.var = myExpl,
                                       resp.xy = myRespXY,
                                       resp.name = myRespName)

  # Model single models
  myBiomodModelOut <- BIOMOD_Modeling(bm.format = myBiomodData,
                                      modeling.id = 'AllModels',
                                      models = c('RF', 'GLM'),
                                      CV.strategy = 'random',
                                      CV.nb.rep = 2,
                                      CV.perc = 0.8,
                                      OPT.strategy = 'bigboss',
                                      metric.eval = c('TSS','ROC'),
                                      var.import = 3,
                                      seed.val = 42)
}


## ----------------------------------------------------------------------- #
# Project single models
myBiomodProj <- BIOMOD_Projection(bm.mod = myBiomodModelOut,
                                  proj.name = 'Current',
                                  new.env = myExpl,
                                  models.chosen = 'all',
                                  metric.binary = 'all',
                                  metric.filter = 'all',
                                  build.clamping.mask = TRUE)
myBiomodProj
plot(myBiomodProj)


}
\seealso{
\code{\link{BIOMOD_Projection}}, \code{\link{BIOMOD_EnsembleForecasting}}

Other Toolbox objects: 
\code{\link{BIOMOD.ensemble.models.out}},
\code{\link{BIOMOD.formated.data}},
\code{\link{BIOMOD.formated.data.PA}},
\code{\link{BIOMOD.models.options}},
\code{\link{BIOMOD.models.out}},
\code{\link{BIOMOD.options.dataset}},
\code{\link{BIOMOD.options.default}},
\code{\link{BIOMOD.stored.data}},
\code{\link{biomod2_ensemble_model}},
\code{\link{biomod2_model}}
}
\author{
Damien Georges
}
\concept{Toolbox objects}
