% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_1.R
\docType{methods}
\name{plot,BIOMOD.formated.data,missing-method}
\alias{plot,BIOMOD.formated.data,missing-method}
\title{\code{plot} method for \code{\link{BIOMOD.formated.data}} object class}
\usage{
\S4method{plot}{BIOMOD.formated.data,missing}(
  x,
  calib.lines = NULL,
  plot.type,
  plot.output,
  PA,
  run,
  plot.eval,
  do.plot = TRUE
)
}
\arguments{
\item{x}{a \code{\link{BIOMOD.formated.data}} or \code{\link{BIOMOD.formated.data.PA}}
object. Coordinates must be available to be able to use \code{plot}.}

\item{calib.lines}{(\emph{optional, default} \code{NULL}) \cr
an \code{array} object returned by \code{\link{get_calib_lines}} or 
\code{\link{bm_CrossValidation}} functions, to explore the distribution of calibration 
and validation datasets}

\item{plot.type}{a \code{character}, either \code{'points'} (\emph{default}) 
or \code{'raster'} (\emph{if environmental variables were given as a raster}). 
With \code{plot.type = 'points'} occurrences will be represented as points
(better when using fine-grained data). With \code{plot.type = 'raster'}
occurrences will be represented as a raster (better when using coarse-grained
data)}

\item{plot.output}{a \code{character}, either \code{'facet'} (\emph{default}) 
or \code{'list'}. \code{plot.output} determines whether plots are returned
as a single facet with all plots or a \code{list} of individual plots
(better when there are numerous graphics)}

\item{PA}{(\emph{optional, default} \code{'all'}) \cr 
If \code{x} is a \code{\link{BIOMOD.formated.data.PA}} object, a \code{vector} 
containing pseudo-absence set to be represented}

\item{run}{(\emph{optional, default} \code{'all'}) \cr 
If \code{calib.lines} provided, a \code{vector} containing repetition set to 
be represented}

\item{plot.eval}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} defining whether evaluation data should be added to the plot or not}

\item{do.plot}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} defining whether the plot is to be rendered or not}
}
\value{
a \code{list} with the data used to generate the plot and a
\code{ggplot2} object
}
\description{
Plot the spatial distribution of presences, absences and 
pseudo-absences among the different potential dataset (calibration, 
validation and evaluation). Available only if coordinates were given to 
\code{\link{BIOMOD_FormatingData}}.
}
\examples{

library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

## ----------------------------------------------------------------------- #
# Format Data with true absences
myBiomodData <- BIOMOD_FormatingData(resp.var = myResp,
                                     expl.var = myExpl,
                                     resp.xy = myRespXY,
                                     resp.name = myRespName)
myBiomodData
plot(myBiomodData)


}
\author{
Remi Patin
}
